/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.accessor.ColumnAccessors;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.ValueType;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractScalarWriterImpl;
import oadd.org.apache.drill.exec.vector.accessor.writer.BaseScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import oadd.org.joda.time.Period;

public class NullableScalarWriter
extends AbstractScalarWriterImpl {
    private final NullableVector nullableVector;
    private final ColumnAccessors.UInt1ColumnWriter isSetWriter;
    private final BaseScalarWriter baseWriter;
    private ColumnWriterIndex writerIndex;

    public NullableScalarWriter(ColumnMetadata schema, NullableVector nullableVector, BaseScalarWriter baseWriter) {
        this.schema = schema;
        this.nullableVector = nullableVector;
        this.isSetWriter = new ColumnAccessors.UInt1ColumnWriter(nullableVector.getBitsVector());
        this.baseWriter = baseWriter;
    }

    public static AbstractScalarWriterImpl.ScalarObjectWriter build(ColumnMetadata schema, NullableVector nullableVector, BaseScalarWriter baseWriter) {
        return new AbstractScalarWriterImpl.ScalarObjectWriter(new NullableScalarWriter(schema, nullableVector, baseWriter));
    }

    public BaseScalarWriter bitsWriter() {
        return this.isSetWriter;
    }

    public BaseScalarWriter baseWriter() {
        return this.baseWriter;
    }

    @Override
    public BaseDataValueVector vector() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.writerIndex = index;
        ChildIndex childIndex = new ChildIndex(index);
        this.isSetWriter.bindIndex(childIndex);
        this.baseWriter.bindIndex(childIndex);
    }

    @Override
    public int rowStartIndex() {
        return this.baseWriter.rowStartIndex();
    }

    @Override
    public ValueType valueType() {
        return this.baseWriter.valueType();
    }

    @Override
    public void restartRow() {
        this.isSetWriter.restartRow();
        this.baseWriter.restartRow();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public void setNull() {
        this.isSetWriter.setInt(0);
        this.baseWriter.skipNulls();
        this.writerIndex.nextElement();
    }

    @Override
    public void setBoolean(boolean value) {
        this.baseWriter.setBoolean(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setInt(int value) {
        this.baseWriter.setInt(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setLong(long value) {
        this.baseWriter.setLong(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setFloat(float value) {
        this.baseWriter.setFloat(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setDouble(double value) {
        this.baseWriter.setDouble(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setString(String value) {
        this.baseWriter.setString(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setBytes(byte[] value, int len) {
        this.baseWriter.setBytes(value, len);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void appendBytes(byte[] value, int len) {
        this.baseWriter.appendBytes(value, len);
    }

    @Override
    public void setDecimal(BigDecimal value) {
        this.baseWriter.setDecimal(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setPeriod(Period value) {
        this.baseWriter.setPeriod(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setDate(LocalDate value) {
        this.baseWriter.setDate(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setTime(LocalTime value) {
        this.baseWriter.setTime(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setTimestamp(Instant value) {
        this.baseWriter.setTimestamp(value);
        this.isSetWriter.setInt(1);
        this.writerIndex.nextElement();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setNull();
        } else {
            this.baseWriter.setValue(value);
            this.isSetWriter.setInt(1);
            this.writerIndex.nextElement();
        }
    }

    @Override
    public void copy(ColumnReader from) {
        if (!from.isNull()) {
            this.isSetWriter.setInt(1);
            this.baseWriter.copy(from);
        }
    }

    @Override
    public void preRollover() {
        this.isSetWriter.preRollover();
        this.baseWriter.preRollover();
    }

    @Override
    public void postRollover() {
        this.isSetWriter.postRollover();
        this.baseWriter.postRollover();
    }

    @Override
    public int lastWriteIndex() {
        return this.baseWriter.lastWriteIndex();
    }

    @Override
    public void bindListener(WriterEvents.ColumnWriterListener listener) {
        this.baseWriter.bindListener(listener);
    }

    @Override
    public void startWrite() {
        this.isSetWriter.startWrite();
        this.baseWriter.startWrite();
    }

    @Override
    public void startRow() {
        this.baseWriter.startRow();
    }

    @Override
    public void endArrayValue() {
        this.baseWriter.endArrayValue();
    }

    @Override
    public void endWrite() {
        this.isSetWriter.endWrite();
        this.baseWriter.skipNulls();
        this.baseWriter.endWrite();
        ((NullableVector.Mutator)this.nullableVector.getMutator()).setSetCount(this.writerIndex.vectorIndex());
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.extend();
        super.dump(format);
        format.attribute("isSetWriter");
        this.isSetWriter.dump(format);
        format.attribute("baseWriter");
        this.baseWriter.dump(format);
        format.endObject();
    }

    @Override
    public void setDefaultValue(Object value) {
        throw new UnsupportedOperationException("Default values not supported for nullable types: " + value);
    }

    public static final class ChildIndex
    implements ColumnWriterIndex {
        private final ColumnWriterIndex parentIndex;

        public ChildIndex(ColumnWriterIndex parentIndex) {
            this.parentIndex = parentIndex;
        }

        @Override
        public int rowStartIndex() {
            return this.parentIndex.rowStartIndex();
        }

        @Override
        public int vectorIndex() {
            return this.parentIndex.vectorIndex();
        }

        @Override
        public void nextElement() {
        }

        @Override
        public void prevElement() {
        }

        @Override
        public void rollover() {
            this.parentIndex.rollover();
        }

        @Override
        public ColumnWriterIndex outerIndex() {
            return this.parentIndex.outerIndex();
        }
    }
}

