/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.io.InputStream;
import java.io.InputStreamReader;
import oadd.com.google.common.base.Charsets;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import oadd.org.apache.drill.exec.vector.NullableVar16CharVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class NullableVar16CharAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.VAR16CHAR);
    private final NullableVar16CharVector.Accessor ac;

    public NullableVar16CharAccessor(NullableVar16CharVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return String.class;
    }

    @Override
    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.getObject(index);
    }

    @Override
    public InputStream getStream(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        NullableVar16CharHolder h2 = new NullableVar16CharHolder();
        this.ac.get(index, h2);
        return new ByteBufInputStream(h2.buffer.slice(h2.start, h2.end));
    }

    @Override
    public byte[] getBytes(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.get(index);
    }

    @Override
    public InputStreamReader getReader(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return new InputStreamReader(this.getStream(index), Charsets.UTF_16);
    }

    @Override
    public String getString(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return new String(this.getBytes(index), Charsets.UTF_16);
    }
}

