/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import oadd.org.joda.time.Period;

public class DateUtilities {
    public static final int yearsToMonths = 12;
    public static final int daysToWeeks = 7;
    public static final int hoursToMillis = 3600000;
    public static final int minutesToMillis = 60000;
    public static final int secondsToMillis = 1000;
    public static final int monthToStandardDays = 30;
    public static final long monthsToMillis = 2592000000L;
    public static final int daysToStandardMillis = 86400000;

    public static int monthsFromPeriod(Period period) {
        return period.getYears() * 12 + period.getMonths();
    }

    public static int periodToMillis(Period period) {
        return period.getHours() * 3600000 + period.getMinutes() * 60000 + period.getSeconds() * 1000 + period.getMillis();
    }

    public static int toMonths(int years, int months) {
        return years * 12 + months;
    }

    public static int periodToMonths(Period value) {
        return value.getYears() * 12 + value.getMonths();
    }

    public static Period fromIntervalYear(int value) {
        int years = value / 12;
        int months = value % 12;
        return new Period().plusYears(years).plusMonths(months);
    }

    public static StringBuilder intervalYearStringBuilder(int months) {
        int years = months / 12;
        return new StringBuilder().append(years).append(DateUtilities.pluralify("year", years)).append(" ").append(months %= 12).append(DateUtilities.pluralify("month", months));
    }

    public static StringBuilder intervalYearStringBuilder(Period value) {
        return DateUtilities.intervalYearStringBuilder(value.getYears() * 12 + value.getMonths());
    }

    public static String pluralify(String term, int value) {
        term = Math.abs(value) == 1 ? term : term + "s";
        return " " + term;
    }

    public static Period fromIntervalDay(int days, int millis) {
        return new Period().plusDays(days).plusMillis(millis);
    }

    public static StringBuilder intervalDayStringBuilder(int days, int millis) {
        int hours = millis / 3600000;
        int minutes = (millis %= 3600000) / 60000;
        int seconds = (millis %= 60000) / 1000;
        StringBuilder buf = new StringBuilder().append(days).append(DateUtilities.pluralify("day", days)).append(" ").append(hours).append(":").append(DateUtilities.asTwoDigits(minutes)).append(":").append(DateUtilities.asTwoDigits(seconds));
        if ((millis %= 1000) != 0) {
            buf.append(".").append(millis);
        }
        return buf;
    }

    public static StringBuilder intervalDayStringBuilder(Period value) {
        return DateUtilities.intervalDayStringBuilder(value.getDays(), DateUtilities.periodToMillis(value));
    }

    public static Period fromInterval(int months, int days, int millis) {
        return new Period().plusMonths(months).plusDays(days).plusMillis(millis);
    }

    public static String asTwoDigits(int value) {
        return String.format("%02d", value);
    }

    public static StringBuilder intervalStringBuilder(int months, int days, int millis) {
        int years = months / 12;
        int hours = millis / 3600000;
        int minutes = (millis %= 3600000) / 60000;
        int seconds = (millis %= 60000) / 1000;
        StringBuilder buf = new StringBuilder().append(years).append(DateUtilities.pluralify("year", years)).append(" ").append(months %= 12).append(DateUtilities.pluralify("month", months)).append(" ").append(days).append(DateUtilities.pluralify("day", days)).append(" ").append(hours).append(":").append(DateUtilities.asTwoDigits(minutes)).append(":").append(DateUtilities.asTwoDigits(seconds));
        if ((millis %= 1000) != 0) {
            buf.append(".").append(millis);
        }
        return buf;
    }

    public static StringBuilder intervalStringBuilder(Period value) {
        return DateUtilities.intervalStringBuilder(value.getYears() * 12 + value.getMonths(), value.getDays(), DateUtilities.periodToMillis(value));
    }

    public static int timeToMillis(int hours, int minutes, int seconds, int millis) {
        return ((hours * 60 + minutes) * 60 + seconds) * 1000 + millis;
    }

    public static int toDrillTime(LocalTime localTime) {
        return (int)((localTime.toNanoOfDay() + 500000L) / 1000000L);
    }

    public static LocalTime fromDrillTime(int value) {
        return LocalTime.ofNanoOfDay((long)value * 1000000L);
    }

    public static long toDrillDate(LocalDate localDate) {
        return localDate.toEpochDay() * 86400000L;
    }

    public static LocalDate fromDrillDate(long value) {
        return LocalDate.ofEpochDay(value / 86400000L);
    }

    public static long toDrillTimestamp(Instant instant) {
        return instant.toEpochMilli();
    }

    public static Instant fromDrillTimestamp(long value) {
        return Instant.ofEpochMilli(value);
    }
}

