/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util.record;

import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.ops.FragmentContextImpl;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.RecordBatchSizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordBatchStats {
    private static final Logger logger = LoggerFactory.getLogger(RecordBatchStats.class);
    public static final String BATCH_STATS_PREFIX = "BATCH_STATS";

    public static void logRecordBatchStats(RecordBatchIOType ioType, String sourceId, RecordBatch recordBatch, RecordBatchStatsContext batchStatsContext) {
        if (!batchStatsContext.isEnableBatchSzLogging()) {
            return;
        }
        RecordBatchStats.logRecordBatchStats(ioType, sourceId, new RecordBatchSizer(recordBatch), batchStatsContext);
    }

    public static void logRecordBatchStats(RecordBatchIOType ioType, RecordBatch recordBatch, RecordBatchStatsContext batchStatsContext) {
        if (!batchStatsContext.isEnableBatchSzLogging()) {
            return;
        }
        RecordBatchStats.logRecordBatchStats(ioType, null, new RecordBatchSizer(recordBatch), batchStatsContext);
    }

    public static void logRecordBatchStats(RecordBatchIOType ioType, RecordBatchSizer recordBatchSizer, RecordBatchStatsContext batchStatsContext) {
        RecordBatchStats.logRecordBatchStats(ioType, null, recordBatchSizer, batchStatsContext);
    }

    public static void logRecordBatchStats(RecordBatchIOType ioType, String sourceId, RecordBatchSizer batchSizer, RecordBatchStatsContext batchStatsContext) {
        if (!batchStatsContext.isEnableBatchSzLogging()) {
            return;
        }
        String statsId = batchStatsContext.getContextOperatorId();
        boolean verbose = batchStatsContext.isEnableFgBatchSzLogging();
        String msg = RecordBatchStats.printRecordBatchStats(statsId, ioType, sourceId, batchSizer, verbose);
        RecordBatchStats.logBatchStatsMsg(batchStatsContext, msg, false);
    }

    public static void logRecordBatchStats(String message, RecordBatchStatsContext batchStatsContext) {
        if (!batchStatsContext.isEnableBatchSzLogging()) {
            return;
        }
        RecordBatchStats.logBatchStatsMsg(batchStatsContext, message, true);
    }

    public static void logRecordBatchStats(RecordBatchStatsContext batchStatsContext, String format, Object ... args) {
        if (!batchStatsContext.isEnableBatchSzLogging()) {
            return;
        }
        String message = String.format(format, args);
        RecordBatchStats.logBatchStatsMsg(batchStatsContext, message, true);
    }

    public static String printAllocatorStats(BufferAllocator allocator) {
        StringBuilder msg = new StringBuilder();
        msg.append(BATCH_STATS_PREFIX);
        msg.append(": dumping allocator statistics:\n");
        msg.append(BATCH_STATS_PREFIX);
        msg.append(": ");
        msg.append(allocator.toString());
        return msg.toString();
    }

    public static void printConfiguredBatchSize(RecordBatchStatsContext batchStatsContext, int batchSize) {
        if (!batchStatsContext.isEnableBatchSzLogging()) {
            return;
        }
        String message = String.format("The batch memory has been set to [%d] byte(s)", batchSize);
        RecordBatchStats.logRecordBatchStats(message, batchStatsContext);
    }

    private RecordBatchStats() {
    }

    private static String printRecordBatchStats(String statsId, RecordBatchIOType ioType, String sourceId, RecordBatchSizer batchSizer, boolean verbose) {
        StringBuilder msg = new StringBuilder();
        msg.append(BATCH_STATS_PREFIX);
        msg.append(" Operator: {");
        msg.append(statsId);
        if (sourceId != null) {
            msg.append(':');
            msg.append(sourceId);
        }
        msg.append("}, IO Type: {");
        msg.append(RecordBatchStats.toString(ioType));
        msg.append("}, Batch size: {");
        msg.append("  Records: ");
        msg.append(batchSizer.rowCount());
        msg.append(", Total size: ");
        msg.append(batchSizer.getActualSize());
        msg.append(", Data size: ");
        msg.append(batchSizer.getNetBatchSize());
        msg.append(", Gross row width: ");
        msg.append(batchSizer.getGrossRowWidth());
        msg.append(", Net row width: ");
        msg.append(batchSizer.getNetRowWidth());
        msg.append(", Density: ");
        msg.append(batchSizer.getAvgDensity());
        msg.append("% }\n");
        if (verbose) {
            msg.append("Batch schema & sizes: {\n");
            for (RecordBatchSizer.ColumnSize colSize : batchSizer.columns().values()) {
                msg.append(BATCH_STATS_PREFIX);
                msg.append("\t");
                msg.append(statsId);
                msg.append('\t');
                msg.append(colSize.toString());
                msg.append(" }\n");
            }
            msg.append(" }\n");
        }
        return msg.toString();
    }

    private static void logBatchStatsMsg(RecordBatchStatsContext batchStatsContext, String msg, boolean includePrefix) {
        if (includePrefix) {
            String statsId = batchStatsContext.getContextOperatorId();
            msg = "BATCH_STATS Operator: {" + statsId + "} " + msg;
        }
        if (batchStatsContext.useInfoLevelLogging()) {
            logger.info(msg);
        } else {
            logger.debug(msg);
        }
    }

    private static String toString(RecordBatchIOType ioType) {
        Preconditions.checkNotNull(ioType, "The record batch IO type cannot be null");
        switch (ioType) {
            case INPUT: {
                return "incoming";
            }
            case INPUT_RIGHT: {
                return "incoming right";
            }
            case INPUT_LEFT: {
                return "incoming left";
            }
            case OUTPUT: {
                return "outgoing";
            }
            case PASSTHROUGH: {
                return "passthrough";
            }
        }
        throw new RuntimeException("Unexpected record batch IO type..");
    }

    public static enum RecordBatchIOType {
        INPUT("incoming"),
        INPUT_RIGHT("incoming right"),
        INPUT_LEFT("incoming left"),
        OUTPUT("outgoing"),
        PASSTHROUGH("passthrough");

        private final String ioTypeString;

        private RecordBatchIOType(String ioTypeString) {
            this.ioTypeString = ioTypeString;
        }

        public String getIOTypeString() {
            return this.ioTypeString;
        }
    }

    public static final class RecordBatchStatsContext {
        private final boolean enableBatchSzLogging;
        private final boolean enableFgBatchSzLogging;
        private final String contextOperatorId;

        public RecordBatchStatsContext(FragmentContext context, OperatorContext oContext) {
            boolean operatorEnabledForStatsLogging = this.isBatchStatsEnabledForOperator(context, oContext);
            if (operatorEnabledForStatsLogging) {
                this.enableBatchSzLogging = context.getOptions().getBoolean("drill.exec.stats.logging.batch_size");
                this.enableFgBatchSzLogging = context.getOptions().getBoolean("drill.exec.stats.logging.fine_grained.batch_size");
            } else {
                this.enableBatchSzLogging = false;
                this.enableFgBatchSzLogging = false;
            }
            this.contextOperatorId = this.getQueryId(context) + ":" + oContext.getStats().getId();
        }

        public boolean isEnableBatchSzLogging() {
            return this.enableBatchSzLogging || this.enableFgBatchSzLogging || logger.isDebugEnabled();
        }

        public boolean isEnableFgBatchSzLogging() {
            return this.enableFgBatchSzLogging || logger.isDebugEnabled();
        }

        public boolean useInfoLevelLogging() {
            return this.isEnableBatchSzLogging() && !logger.isDebugEnabled();
        }

        public String getContextOperatorId() {
            return this.contextOperatorId;
        }

        private String getQueryId(FragmentContext _context) {
            FragmentContextImpl context;
            ExecProtos.FragmentHandle handle;
            if (_context instanceof FragmentContextImpl && (handle = (context = (FragmentContextImpl)_context).getHandle()) != null) {
                return QueryIdHelper.getQueryIdentifier(handle);
            }
            return "NA";
        }

        private boolean isBatchStatsEnabledForOperator(FragmentContext context, OperatorContext oContext) {
            String statsLoggingOperator = context.getOptions().getString("drill.exec.stats.logging.enabled_operators").toUpperCase();
            String allOperatorsStr = "ALL";
            if ("ALL".equals(statsLoggingOperator)) {
                return true;
            }
            String[] operators = statsLoggingOperator.split(",");
            String operatorId = oContext.getStats().getId().toUpperCase();
            for (int idx = 0; idx < operators.length; ++idx) {
                if (!operatorId.contains(operators[idx].trim())) continue;
                return true;
            }
            return false;
        }
    }
}

