/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.io.BaseEncoding;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.SchemaPath;

public class EncodedSchemaPathSet {
    private static final int ESTIMATED_ENCODED_SIZE = 1024;
    private static final String ENC_PREFIX = "$$ENC";
    private static final String ENC_FORMAT_STRING = "$$ENC%02d%s";
    private static final int ENC_PREFIX_SIZE = "$$ENC".length() + "00".length();
    private static final int MAX_ENC_IDENTIFIER_SIZE = 1024 - ENC_PREFIX_SIZE;
    private static final int MAX_ENC_IDENTIFIER_COUNT = 100;
    private static final BaseEncoding CODEC = BaseEncoding.base32().omitPadding();
    public static final String ENCODED_STAR_COLUMN = EncodedSchemaPathSet.encode("*")[0];
    private static final String UTF_8 = "utf-8";

    private static byte[] encodeUTF(String input) {
        try {
            return input.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new DrillRuntimeException(e);
        }
    }

    private static String decodeUTF(byte[] input) {
        try {
            return new String(input, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new DrillRuntimeException(e);
        }
    }

    private static String decodeUTF(byte[] input, int offset, int length) {
        try {
            return new String(input, offset, length, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new DrillRuntimeException(e);
        }
    }

    public static String[] encode(String ... schemaPaths) {
        Preconditions.checkArgument(schemaPaths != null && schemaPaths.length > 0, "At least one schema path should be provided");
        NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream(1024);
        int bufOffset = 1;
        for (String schemaPath : schemaPaths) {
            out.write(0);
            out.write(EncodedSchemaPathSet.encodeUTF(schemaPath));
        }
        out.close();
        int bufLen = out.size() - 1;
        String encodedStr = CODEC.encode(out.getBuffer(), bufOffset, bufLen);
        assert (!encodedStr.endsWith("=")) : String.format("Encoded string '%s' ends with '='", encodedStr);
        return EncodedSchemaPathSet.splitIdentifiers(encodedStr);
    }

    public static boolean isEncodedSchemaPath(SchemaPath schemaPath) {
        return schemaPath != null && EncodedSchemaPathSet.isEncodedSchemaPath(schemaPath.getRootSegment().getNameSegment().getPath());
    }

    public static boolean isEncodedSchemaPath(String schemaPath) {
        return schemaPath != null && schemaPath.startsWith(ENC_PREFIX);
    }

    public static Collection<SchemaPath> decode(Collection<SchemaPath> encodedPaths) {
        String[] schemaPathStrings = new String[encodedPaths.size()];
        Iterator<SchemaPath> encodedPathsItr = encodedPaths.iterator();
        for (int i = 0; i < schemaPathStrings.length; ++i) {
            SchemaPath schemaPath = encodedPathsItr.next();
            schemaPathStrings[i] = schemaPath.getRootSegmentPath().startsWith(ENC_PREFIX) ? schemaPath.getRootSegmentPath() : schemaPath.toExpr();
        }
        String[] decodedStrings = EncodedSchemaPathSet.decode(schemaPathStrings);
        if (decodedStrings == schemaPathStrings) {
            return encodedPaths;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String decodedString : decodedStrings) {
            if ("*".equals(decodedString) || "`*`".equals(decodedString)) {
                builder.add(SchemaPath.STAR_COLUMN);
                continue;
            }
            builder.add(SchemaPath.parseFromString(decodedString, true));
        }
        return builder.build();
    }

    public static String[] decode(String ... encodedPaths) {
        Preconditions.checkArgument(encodedPaths != null && encodedPaths.length > 0, "At least one encoded path should be provided");
        StringBuilder sb = new StringBuilder(1024);
        Arrays.sort(encodedPaths);
        ArrayList<String> decodedPathList = Lists.newArrayList();
        for (String encodedPath : encodedPaths) {
            if (encodedPath.startsWith(ENC_PREFIX)) {
                sb.append(encodedPath, ENC_PREFIX_SIZE, encodedPath.length());
                continue;
            }
            decodedPathList.add(encodedPath);
        }
        if (sb.length() > 0) {
            String lastSchemaPath;
            int index;
            byte[] decodedBytes;
            try {
                decodedBytes = CODEC.decode(sb);
            }
            catch (IllegalArgumentException e) {
                throw new DrillRuntimeException(String.format("Unable to decode the input strings as encoded schema paths:\n%s", Arrays.asList(encodedPaths)), e);
            }
            int start = 0;
            for (index = 0; index < decodedBytes.length; ++index) {
                if (decodedBytes[index] != 0 || index - start <= 0) continue;
                decodedPathList.add(EncodedSchemaPathSet.decodeUTF(decodedBytes, start, index - start));
                start = index + 1;
            }
            if (index - start > 0 && !(lastSchemaPath = EncodedSchemaPathSet.decodeUTF(decodedBytes, start, index - start).trim()).isEmpty()) {
                decodedPathList.add(lastSchemaPath);
            }
            return decodedPathList.toArray(new String[decodedPathList.size()]);
        }
        return encodedPaths;
    }

    private static String[] splitIdentifiers(String input) {
        if (input.length() < MAX_ENC_IDENTIFIER_SIZE) {
            return new String[]{String.format(ENC_FORMAT_STRING, 0, input)};
        }
        int splitsCount = (int)Math.ceil((double)input.length() / (double)MAX_ENC_IDENTIFIER_SIZE);
        if (splitsCount > 100) {
            throw new DrillRuntimeException(String.format("Encoded size of the SchemaPath identifier '%s' exceeded maximum value.", input));
        }
        String[] result = new String[splitsCount];
        int i = 0;
        int startIdx = 0;
        while (i < result.length) {
            result[i] = String.format(ENC_FORMAT_STRING, i, input.substring(startIdx, Math.min(input.length(), startIdx + MAX_ENC_IDENTIFIER_SIZE)));
            ++i;
            startIdx += MAX_ENC_IDENTIFIER_SIZE;
        }
        return result;
    }

    private static class NoCopyByteArrayOutputStream
    extends ByteArrayOutputStream {
        public NoCopyByteArrayOutputStream(int size) {
            super(size);
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public void write(int b) {
            super.write(b);
        }

        @Override
        public void write(byte[] b) {
            super.write(b, 0, b.length);
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new DrillRuntimeException(e);
            }
        }
    }
}

