/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user.clusterclient;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oadd.com.google.common.base.Strings;
import oadd.com.google.common.util.concurrent.MoreExecutors;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.config.DrillProperties;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.rpc.NamedThreadFactory;
import oadd.org.apache.drill.exec.rpc.NonTransientRpcException;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.AbstractDrillClusterClientBuilder;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillClusterClient;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillConnectionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDrillClusterClient
implements DrillClusterClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDrillClusterClient.class);
    final String clientName;
    final DrillConfig config;
    final boolean supportComplexTypes;
    final BufferAllocator allocator;
    final EventLoopGroup eventLoopGroup;
    final ExecutorService executor;
    private final boolean ownsAllocator;
    private final boolean ownsEventLoopGroup;
    private final boolean ownsExecutor;

    protected AbstractDrillClusterClient(AbstractDrillClusterClientBuilder<?, ?> builder) {
        this.clientName = builder.name;
        this.config = builder.config != null ? builder.config : DrillConfig.create();
        this.supportComplexTypes = builder.supportComplexTypes;
        this.ownsAllocator = builder.allocator == null;
        this.allocator = !this.ownsAllocator ? builder.allocator : RootAllocatorFactory.newRoot(this.config);
        this.ownsEventLoopGroup = builder.eventLoopGroup == null;
        this.eventLoopGroup = !this.ownsEventLoopGroup ? builder.eventLoopGroup : TransportCheck.createEventLoopGroup(builder.eventLoopGroupSize, "Client-");
        this.ownsExecutor = builder.executor == null;
        this.executor = !this.ownsExecutor ? builder.executor : new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), new NamedThreadFactory("drill-client-executor-")){

            @Override
            protected void afterExecute(Runnable r, Throwable t2) {
                if (t2 != null) {
                    logger.error(String.format("%s.run() leaked an exception.", r.getClass().getName()), t2);
                }
                super.afterExecute(r, t2);
            }
        };
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    protected static UserBitShared.UserCredentials getUserCredentials(DrillProperties properties) {
        String userName = properties.getProperty("user");
        if (Strings.isNullOrEmpty(userName)) {
            userName = "anonymous";
        }
        return UserBitShared.UserCredentials.newBuilder().setUserName(userName).build();
    }

    protected final DrillConnectionImpl newPhysicalConnection(CoordinationProtos.DrillbitEndpoint endpoint, Properties props) throws NonTransientRpcException {
        return new DrillConnectionImpl(this, endpoint, props);
    }

    protected abstract void connectionClosedDirectly(CoordinationProtos.DrillbitEndpoint var1);

    protected abstract void closeAllConnections();

    @Override
    public void close() {
        this.closeAllConnections();
        if (this.ownsAllocator) {
            try {
                AutoCloseables.close(this.allocator);
            }
            catch (Exception e) {
                logger.error("Could not close allocator cleanly", e);
            }
        }
        if (this.ownsEventLoopGroup) {
            TransportCheck.shutDownEventLoopGroup(this.eventLoopGroup, "Client-", logger);
        }
        if (this.ownsExecutor && !MoreExecutors.shutdownAndAwaitTermination(this.executor, 1L, TimeUnit.SECONDS)) {
            logger.error("Executor could not terminate.");
        }
    }
}

