/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resourcemgr.config;

import java.util.List;
import java.util.Map;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.typesafe.config.Config;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.resourcemgr.NodeResources;
import oadd.org.apache.drill.exec.resourcemgr.config.QueryQueueConfig;
import oadd.org.apache.drill.exec.resourcemgr.config.QueryQueueConfigImpl;
import oadd.org.apache.drill.exec.resourcemgr.config.QueueAssignmentResult;
import oadd.org.apache.drill.exec.resourcemgr.config.ResourcePool;
import oadd.org.apache.drill.exec.resourcemgr.config.exception.RMConfigException;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.DefaultSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.ResourcePoolSelector;
import oadd.org.apache.drill.exec.resourcemgr.config.selectors.ResourcePoolSelectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePoolImpl
implements ResourcePool {
    private static final Logger logger = LoggerFactory.getLogger(ResourcePoolImpl.class);
    public static final String POOL_NAME_KEY = "pool_name";
    public static final String POOL_MEMORY_SHARE_KEY = "memory";
    public static final String POOL_CHILDREN_POOLS_KEY = "child_pools";
    public static final String POOL_SELECTOR_KEY = "selector";
    public static final String POOL_QUEUE_KEY = "queue";
    private String poolName;
    private List<ResourcePool> childPools;
    private final double parentResourceShare;
    private final double poolResourceShare;
    private QueryQueueConfig assignedQueue;
    private final ResourcePoolSelector assignedSelector;
    private NodeResources poolResourcePerNode;
    private final ResourcePool parentPool;

    ResourcePoolImpl(Config poolConfig, double poolAbsResourceShare, double parentResourceShare, NodeResources parentNodeResource, ResourcePool parentPool, Map<String, QueryQueueConfig> leafQueueCollector) throws RMConfigException {
        try {
            this.poolName = poolConfig.getString(POOL_NAME_KEY);
            this.parentResourceShare = parentResourceShare;
            this.poolResourceShare = poolAbsResourceShare * this.parentResourceShare;
            this.parentPool = parentPool;
            this.assignedSelector = ResourcePoolSelectorFactory.createSelector(poolConfig.hasPath(POOL_SELECTOR_KEY) ? poolConfig.getConfig(POOL_SELECTOR_KEY) : null);
            this.parseAndCreateChildPools(poolConfig, parentNodeResource, leafQueueCollector);
        }
        catch (RMConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RMConfigException(String.format("Failure while parsing configuration for pool: %s. [Details: PoolConfig: %s]", this.poolName, poolConfig), ex);
        }
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public boolean isLeafPool() {
        return this.childPools == null && this.assignedQueue != null;
    }

    @Override
    public boolean isDefaultPool() {
        return this.assignedSelector instanceof DefaultSelector;
    }

    @Override
    public long getMaxQueryMemoryPerNode() {
        Preconditions.checkState(this.isLeafPool() && this.assignedQueue != null, "max_query_memory_per_node is only valid for leaf level pools which has a queue assigned to it [Details: PoolName: %s]", (Object)this.poolName);
        return this.assignedQueue.getMaxQueryMemoryInMBPerNode();
    }

    @Override
    public void visitAndSelectPool(QueueAssignmentResult assignmentResult, QueryContext queryContext) {
        if (this.assignedSelector.isQuerySelected(queryContext)) {
            if (this.isLeafPool()) {
                assignmentResult.addSelectedPool(this);
            } else {
                for (ResourcePool childPool : this.childPools) {
                    childPool.visitAndSelectPool(assignmentResult, queryContext);
                }
            }
        } else {
            assignmentResult.addRejectedPool(this);
        }
    }

    @Override
    public double getPoolMemoryShare() {
        return this.poolResourceShare;
    }

    @Override
    public long getPoolMemoryInMB(int numClusterNodes) {
        return this.poolResourcePerNode.getMemoryInMB() * (long)numClusterNodes;
    }

    private void parseAndCreateChildPools(Config poolConfig, NodeResources parentResource, Map<String, QueryQueueConfig> leafQueueCollector) throws RMConfigException {
        this.poolResourcePerNode = new NodeResources(Math.round((double)parentResource.getMemoryInBytes() * this.poolResourceShare), parentResource.getNumVirtualCpu());
        if (poolConfig.hasPath(POOL_CHILDREN_POOLS_KEY)) {
            this.childPools = Lists.newArrayList();
            List<? extends Config> childPoolsConfig = poolConfig.getConfigList(POOL_CHILDREN_POOLS_KEY);
            logger.debug("Creating {} child pools for parent pool {}", (Object)childPoolsConfig.size(), (Object)this.poolName);
            for (Config config : childPoolsConfig) {
                try {
                    ResourcePoolImpl childPool = new ResourcePoolImpl(config, config.getDouble(POOL_MEMORY_SHARE_KEY), this.poolResourceShare, this.poolResourcePerNode, this, leafQueueCollector);
                    this.childPools.add(childPool);
                }
                catch (RMConfigException ex) {
                    logger.error("Failure while configuring child ResourcePool. [Details: PoolName: {}, ChildPoolConfig with error: {}]", (Object)this.poolName, (Object)config);
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RMConfigException(String.format("Failure while configuring the child ResourcePool. [Details: PoolName: %s, ChildPoolConfig with error: %s]", this.poolName, config), ex);
                }
            }
            if (this.childPools.isEmpty()) {
                throw new RMConfigException(String.format("Empty config for child_pools is not allowed. Please configure the child_pools property of pool %s correctly or associate a queue with it with no child_pools", this.poolName));
            }
        } else {
            logger.info("Resource Pool {} is a leaf level pool with queue assigned to it", (Object)this.poolName);
            if (leafQueueCollector.containsKey(this.poolName)) {
                throw new RMConfigException(String.format("Found non-unique leaf pools with name: %s and config: %s. Leaf pool names has to be unique since they represent a queue.", this.poolName, poolConfig));
            }
            this.assignedQueue = new QueryQueueConfigImpl(poolConfig.getConfig(POOL_QUEUE_KEY), this.poolName, this.poolResourcePerNode);
            leafQueueCollector.put(this.poolName, this.assignedQueue);
        }
    }

    @Override
    public QueryQueueConfig getQueryQueue() {
        Preconditions.checkState(this.isLeafPool() && this.assignedQueue != null, "QueryQueue is only valid for leaf level pools.[Details: PoolName: %s]", (Object)this.poolName);
        return this.assignedQueue;
    }

    @Override
    public ResourcePool getParentPool() {
        return this.parentPool;
    }

    @Override
    public String getFullPath() {
        StringBuilder pathBuilder = new StringBuilder(this.poolName);
        for (ResourcePool parent = this.parentPool; parent != null; parent = parent.getParentPool()) {
            pathBuilder.append(parent.getPoolName());
        }
        return pathBuilder.toString();
    }

    @Override
    public List<ResourcePool> getChildPools() {
        Preconditions.checkState(!this.isLeafPool() && this.assignedQueue == null, "There are no child pools for a leaf ResourcePool");
        return this.childPools;
    }

    @Override
    public ResourcePoolSelector getSelector() {
        return this.assignedSelector;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{PoolName: ").append(this.poolName);
        sb.append(", PoolResourceShare: ").append(this.poolResourceShare);
        sb.append(", Selector: ").append((Object)this.assignedSelector.getSelectorType());
        if (this.isLeafPool()) {
            sb.append(", Queue: [").append(this.assignedQueue.toString()).append("]");
        } else {
            sb.append(", ChildPools: [");
            for (ResourcePool childPool : this.childPools) {
                sb.append(childPool.toString());
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }
}

