/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oadd.com.google.common.base.Function;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.config.LogicalPlanPersistence;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.ExecConstants;
import oadd.org.apache.drill.exec.alias.AliasRegistryProvider;
import oadd.org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import oadd.org.apache.drill.exec.expr.fn.registry.RemoteFunctionRegistry;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.BufferManager;
import oadd.org.apache.drill.exec.ops.BufferManagerImpl;
import oadd.org.apache.drill.exec.ops.ContextInformation;
import oadd.org.apache.drill.exec.ops.OptimizerRulesContext;
import oadd.org.apache.drill.exec.ops.ViewExpansionContext;
import oadd.org.apache.drill.exec.planner.physical.PlannerSettings;
import oadd.org.apache.drill.exec.planner.sql.DrillOperatorTable;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.user.UserSession;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.server.QueryProfileStoreContext;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.server.options.QueryOptionManager;
import oadd.org.apache.drill.exec.store.PartitionExplorer;
import oadd.org.apache.drill.exec.store.PartitionExplorerImpl;
import oadd.org.apache.drill.exec.store.SchemaConfig;
import oadd.org.apache.drill.exec.store.SchemaTreeProvider;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.testing.ExecutionControls;
import oadd.org.apache.drill.exec.util.Utilities;
import org.apache.drill.metastore.MetastoreRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryContext
implements AutoCloseable,
OptimizerRulesContext,
SchemaConfig.SchemaConfigInfoProvider {
    private static final Logger logger = LoggerFactory.getLogger(QueryContext.class);
    private final DrillbitContext drillbitContext;
    private final UserSession session;
    private final UserBitShared.QueryId queryId;
    private final QueryOptionManager queryOptions;
    private final PlannerSettings plannerSettings;
    private final ExecutionControls executionControls;
    private final BufferAllocator allocator;
    private final BufferManager bufferManager;
    private final ContextInformation contextInformation;
    private final BitControl.QueryContextInformation queryContextInfo;
    private final ViewExpansionContext viewExpansionContext;
    private final SchemaTreeProvider schemaTreeProvider;
    private boolean skipProfileWrite;
    private final Map<String, Map<TypeProtos.MinorType, ValueHolder>> constantValueHolderCache;
    private SqlStatementType stmtType;
    private boolean closed = false;
    private DrillOperatorTable table;

    public QueryContext(UserSession session, DrillbitContext drillbitContext, UserBitShared.QueryId queryId) {
        this.drillbitContext = drillbitContext;
        this.session = session;
        this.queryId = queryId;
        this.skipProfileWrite = false;
        this.queryOptions = new QueryOptionManager(session.getOptions());
        this.executionControls = new ExecutionControls(this.queryOptions, drillbitContext.getEndpoint());
        this.plannerSettings = new PlannerSettings((OptionManager)this.queryOptions, this.getFunctionRegistry());
        this.plannerSettings.setNumEndPoints(drillbitContext.getBits().size());
        this.table = this.queryOptions.getOption(ExecConstants.USE_DYNAMIC_UDFS) ? new DrillOperatorTable(drillbitContext.getFunctionImplementationRegistry(), (OptionManager)drillbitContext.getOptionManager()) : drillbitContext.getOperatorTable();
        int sessionMaxRowCount = this.queryOptions.getOption((String)"exec.query.max_rows").num_val.intValue();
        int defaultMaxRowCount = this.queryOptions.getOptionManager((OptionValue.OptionScope)OptionValue.OptionScope.SYSTEM).getOption((String)"exec.query.max_rows").num_val.intValue();
        int autoLimitRowCount = 0;
        autoLimitRowCount = sessionMaxRowCount > 0 && defaultMaxRowCount > 0 ? Math.min(sessionMaxRowCount, defaultMaxRowCount) : Math.max(sessionMaxRowCount, defaultMaxRowCount);
        if (autoLimitRowCount == defaultMaxRowCount && defaultMaxRowCount != sessionMaxRowCount) {
            this.queryOptions.setLocalOption("exec.query.max_rows", autoLimitRowCount);
        }
        if (autoLimitRowCount > 0) {
            logger.debug("ResultSet size is auto-limited to {} rows [Session: {} / Default: {}]", autoLimitRowCount, sessionMaxRowCount, defaultMaxRowCount);
        }
        this.queryContextInfo = Utilities.createQueryContextInfo(session.getDefaultSchemaPath(), session.getSessionId());
        this.contextInformation = new ContextInformation(session.getCredentials(), this.queryContextInfo);
        this.allocator = drillbitContext.getAllocator().newChildAllocator("query:" + QueryIdHelper.getQueryId(queryId), PlannerSettings.getInitialPlanningMemorySize(), this.plannerSettings.getPlanningMemoryLimit());
        this.bufferManager = new BufferManagerImpl(this.allocator);
        this.viewExpansionContext = new ViewExpansionContext(this);
        this.schemaTreeProvider = new SchemaTreeProvider(drillbitContext);
        this.constantValueHolderCache = Maps.newHashMap();
        this.stmtType = null;
    }

    @Override
    public PlannerSettings getPlannerSettings() {
        return this.plannerSettings;
    }

    public UserSession getSession() {
        return this.session;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public UserBitShared.QueryId getQueryId() {
        return this.queryId;
    }

    public SchemaPlus getNewDefaultSchema() {
        SchemaPlus rootSchema = this.getRootSchema();
        SchemaPlus defaultSchema = this.session.getDefaultSchema(rootSchema);
        if (defaultSchema == null) {
            return rootSchema;
        }
        return defaultSchema;
    }

    public SchemaPlus getRootSchema() {
        return this.getRootSchema(this.getQueryUserName());
    }

    public SchemaPlus getRootSchema(String userName) {
        return this.schemaTreeProvider.createRootSchema(userName, (SchemaConfig.SchemaConfigInfoProvider)this);
    }

    public SchemaPlus getRootSchema(SchemaConfig schemaConfig) {
        return this.schemaTreeProvider.createRootSchema(schemaConfig);
    }

    public String getQueryUserName() {
        return this.session.getCredentials().getUserName();
    }

    public QueryOptionManager getOptions() {
        return this.queryOptions;
    }

    public ExecutionControls getExecutionControls() {
        return this.executionControls;
    }

    public CoordinationProtos.DrillbitEndpoint getCurrentEndpoint() {
        return this.drillbitContext.getEndpoint();
    }

    public StoragePluginRegistry getStorage() {
        return this.drillbitContext.getStorage();
    }

    public LogicalPlanPersistence getLpPersistence() {
        return this.drillbitContext.getLpPersistence();
    }

    public Collection<CoordinationProtos.DrillbitEndpoint> getActiveEndpoints() {
        return this.drillbitContext.getBits();
    }

    public Collection<CoordinationProtos.DrillbitEndpoint> getOnlineEndpoints() {
        return this.drillbitContext.getBits();
    }

    public DrillConfig getConfig() {
        return this.drillbitContext.getConfig();
    }

    public QueryProfileStoreContext getProfileStoreContext() {
        return this.drillbitContext.getProfileStoreContext();
    }

    @Override
    public FunctionImplementationRegistry getFunctionRegistry() {
        return this.drillbitContext.getFunctionImplementationRegistry();
    }

    public ViewExpansionContext getViewExpansionContext() {
        return this.viewExpansionContext;
    }

    public OptionValue getOption(String optionKey) {
        return this.getOptions().getOption(optionKey);
    }

    public boolean isImpersonationEnabled() {
        return this.getConfig().getBoolean("drill.exec.impersonation.enabled");
    }

    public boolean isUserAuthenticationEnabled() {
        return this.getConfig().getBoolean("drill.exec.security.user.auth.enabled");
    }

    public boolean isRuntimeFilterEnabled() {
        return this.getOption((String)"exec.hashjoin.enable.runtime_filter").bool_val;
    }

    public DrillOperatorTable getDrillOperatorTable() {
        return this.table;
    }

    public void reloadDrillOperatorTable() {
        this.clearSQLStatementType();
        this.table = new DrillOperatorTable(this.drillbitContext.getFunctionImplementationRegistry(), (OptionManager)this.drillbitContext.getOptionManager());
    }

    public BitControl.QueryContextInformation getQueryContextInfo() {
        return this.queryContextInfo;
    }

    public RemoteFunctionRegistry getRemoteFunctionRegistry() {
        return this.drillbitContext.getRemoteFunctionRegistry();
    }

    @Override
    public ContextInformation getContextInformation() {
        return this.contextInformation;
    }

    @Override
    public DrillBuf getManagedBuffer() {
        return this.bufferManager.getManagedBuffer();
    }

    @Override
    public PartitionExplorer getPartitionExplorer() {
        return new PartitionExplorerImpl(this.getRootSchema());
    }

    @Override
    public ValueHolder getConstantValueHolder(String value, TypeProtos.MinorType type, Function<DrillBuf, ValueHolder> holderInitializer) {
        Map<TypeProtos.MinorType, ValueHolder> holdersByType;
        ValueHolder valueHolder;
        if (!this.constantValueHolderCache.containsKey(value)) {
            this.constantValueHolderCache.put(value, Maps.newHashMap());
        }
        if ((valueHolder = (holdersByType = this.constantValueHolderCache.get(value)).get(type)) == null) {
            valueHolder = holderInitializer.apply(this.getManagedBuffer());
            holdersByType.put(type, valueHolder);
        }
        return valueHolder;
    }

    @Override
    public void close() throws Exception {
        try {
            if (!this.closed) {
                ArrayList<AutoCloseable> toClose = Lists.newArrayList();
                toClose.add(this.bufferManager);
                toClose.add(this.allocator);
                toClose.add((AutoCloseable)this.schemaTreeProvider);
                AutoCloseables.close(toClose);
            }
        }
        finally {
            this.closed = true;
        }
    }

    public void setSQLStatementType(SqlStatementType stmtType) {
        if (this.stmtType != null) {
            throw new IllegalStateException(String.format("SQL Statement type is already set to %s", new Object[]{this.stmtType}));
        }
        this.stmtType = stmtType;
    }

    public void clearSQLStatementType() {
        this.stmtType = null;
    }

    public SqlStatementType getSQLStatementType() {
        return this.stmtType;
    }

    public void skipWritingProfile(boolean skipWriting) {
        this.skipProfileWrite = skipWriting;
    }

    public boolean isSkipProfileWrite() {
        return this.skipProfileWrite;
    }

    public MetastoreRegistry getMetastoreRegistry() {
        return this.drillbitContext.getMetastoreRegistry();
    }

    public AliasRegistryProvider getAliasRegistryProvider() {
        return this.drillbitContext.getAliasRegistryProvider();
    }

    public static enum SqlStatementType {
        OTHER,
        ANALYZE,
        CTAS,
        EXPLAIN,
        DESCRIBE_TABLE,
        DESCRIBE_SCHEMA,
        REFRESH,
        SELECT,
        SETOPTION;

    }
}

