/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.oauth;

import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.exec.oauth.PersistentTokenRegistry;
import oadd.org.apache.drill.exec.oauth.TokenRegistry;
import oadd.org.apache.drill.exec.server.DrillbitContext;

public class OAuthTokenProvider
implements AutoCloseable {
    private static final String STORAGE_REGISTRY_PATH = "oauth_tokens";
    private final DrillbitContext context;
    private PersistentTokenRegistry oauthTokenRegistry;

    public OAuthTokenProvider(DrillbitContext context) {
        this.context = context;
    }

    public TokenRegistry getOauthTokenRegistry() {
        if (this.oauthTokenRegistry == null) {
            this.initRemoteRegistries();
        }
        return this.oauthTokenRegistry;
    }

    private synchronized void initRemoteRegistries() {
        if (this.oauthTokenRegistry == null) {
            this.oauthTokenRegistry = new PersistentTokenRegistry(this.context, STORAGE_REGISTRY_PATH);
        }
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.closeSilently(this.oauthTokenRegistry);
    }
}

