/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metastore.store;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.exception.MetadataException;
import oadd.org.apache.drill.exec.metastore.MetastoreMetadataProviderManager;
import oadd.org.apache.drill.exec.metastore.store.FileSystemMetadataProviderManager;
import oadd.org.apache.drill.exec.metastore.store.FileTableMetadataProviderBuilder;
import oadd.org.apache.drill.exec.metastore.store.SimpleFileTableMetadataProvider;
import oadd.org.apache.drill.exec.planner.common.DrillStatsTable;
import oadd.org.apache.drill.exec.record.SchemaUtil;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.drill.exec.store.dfs.FileSelection;
import oadd.org.apache.drill.exec.store.parquet.ParquetTableMetadataUtils;
import oadd.org.apache.drill.exec.util.DrillFileSystemUtil;
import org.apache.drill.metastore.components.tables.BasicTablesRequests;
import org.apache.drill.metastore.components.tables.MetastoreTableInfo;
import org.apache.drill.metastore.metadata.BaseTableMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.NonInterestingColumnsMetadata;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.metadata.TableMetadataProvider;
import org.apache.drill.metastore.metadata.TableMetadataProviderBuilder;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsHolder;
import org.apache.drill.metastore.util.SchemaPathUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreFileTableMetadataProvider
implements TableMetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(MetastoreFileTableMetadataProvider.class);
    protected final BasicTablesRequests basicTablesRequests;
    protected final TableInfo tableInfo;
    protected final MetastoreTableInfo metastoreTableInfo;
    protected final TupleMetadata schema;
    protected final List<String> paths;
    protected final DrillStatsTable statsProvider;
    protected final TableMetadataProviderBuilder fallbackBuilder;
    protected final boolean useSchema;
    protected final boolean useStatistics;
    protected final boolean fallbackToFileMetadata;
    protected BaseTableMetadata tableMetadata;
    protected Map<Path, SegmentMetadata> segmentsMetadata;
    protected List<PartitionMetadata> partitions;
    protected Map<Path, FileMetadata> files;
    private NonInterestingColumnsMetadata nonInterestingColumnsMetadata;

    protected MetastoreFileTableMetadataProvider(Builder<?> builder) {
        SchemaProvider schemaProvider = builder.metadataProviderManager.getSchemaProvider();
        TupleMetadata schema = builder.schema;
        if (schema == null && schemaProvider != null) {
            try {
                schema = schemaProvider.read().getSchema();
            }
            catch (IOException e) {
                logger.warn("Unable to read schema from schema provider [{}]: {}.\nQuery execution will continue without using the schema.", (Object)builder.metadataProviderManager.getTableInfo().name(), (Object)e.getMessage());
                logger.trace("Error when reading the schema", e);
            }
        }
        this.basicTablesRequests = builder.metadataProviderManager.getMetastoreRegistry().get().tables().basicRequests();
        this.tableInfo = builder.metadataProviderManager.getTableInfo();
        this.metastoreTableInfo = this.basicTablesRequests.metastoreTableInfo(this.tableInfo);
        this.useSchema = builder.metadataProviderManager.getConfig().useSchema();
        this.useStatistics = builder.metadataProviderManager.getConfig().useStatistics();
        this.fallbackToFileMetadata = builder.metadataProviderManager.getConfig().fallbackToFileMetadata();
        this.schema = schema;
        this.fallbackBuilder = builder.fallback;
        this.statsProvider = builder.metadataProviderManager.getStatsProvider();
        this.paths = builder.paths;
        TableMetadataProvider source = builder.metadataProviderManager.getTableMetadataProvider();
        if (source == null || source.getFilesMetadataMap().size() < this.getFilesMetadataMap().size()) {
            builder.metadataProviderManager.setTableMetadataProvider(this);
        }
    }

    protected void throwIfChanged() {
        if (this.basicTablesRequests.hasMetastoreTableInfoChanged(this.metastoreTableInfo)) {
            throw MetadataException.of(MetadataException.MetadataExceptionType.INCONSISTENT_METADATA);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TableMetadata getTableMetadata() {
        this.throwIfChanged();
        if (this.tableMetadata != null) return this.tableMetadata;
        if (this.schema == null) {
            if (!this.useSchema) throw MetadataException.of(MetadataException.MetadataExceptionType.ABSENT_SCHEMA);
            this.tableMetadata = this.basicTablesRequests.tableMetadata(this.tableInfo);
        } else {
            this.tableMetadata = ((BaseTableMetadata.BaseTableMetadataBuilder)this.basicTablesRequests.tableMetadata(this.tableInfo).toBuilder().schema(this.schema)).build();
        }
        if (!this.useStatistics) {
            this.tableMetadata = ((BaseTableMetadata.BaseTableMetadataBuilder)this.tableMetadata.toBuilder().columnsStatistics(Collections.emptyMap())).build();
        }
        if (this.statsProvider == null) return this.tableMetadata;
        if (!this.statsProvider.isMaterialized()) {
            this.statsProvider.materialize();
        }
        this.tableMetadata = this.tableMetadata.cloneWithStats(ParquetTableMetadataUtils.getColumnStatistics((TupleMetadata)this.tableMetadata.getSchema(), (DrillStatsTable)this.statsProvider), DrillStatsTable.getEstimatedTableStats((DrillStatsTable)this.statsProvider));
        return this.tableMetadata;
    }

    public List<SchemaPath> getPartitionColumns() {
        this.throwIfChanged();
        return this.basicTablesRequests.interestingColumnsAndPartitionKeys(this.tableInfo).partitionKeys().values().stream().map(SchemaPath::getSimplePath).collect(Collectors.toList());
    }

    public List<PartitionMetadata> getPartitionsMetadata() {
        this.throwIfChanged();
        if (this.partitions == null) {
            this.partitions = this.basicTablesRequests.partitionsMetadata(this.tableInfo, null, null);
        }
        return this.partitions;
    }

    public List<PartitionMetadata> getPartitionMetadata(SchemaPath columnName) {
        this.throwIfChanged();
        return this.basicTablesRequests.partitionsMetadata(this.tableInfo, null, columnName.getRootSegmentPath());
    }

    public Map<Path, FileMetadata> getFilesMetadataMap() {
        this.throwIfChanged();
        if (this.files == null) {
            this.files = this.basicTablesRequests.filesMetadata(this.tableInfo, null, this.paths).stream().collect(Collectors.toMap(FileMetadata::getPath, Function.identity()));
        }
        return this.files;
    }

    public Map<Path, SegmentMetadata> getSegmentsMetadataMap() {
        this.throwIfChanged();
        if (this.segmentsMetadata == null) {
            this.segmentsMetadata = this.basicTablesRequests.segmentsMetadataByColumn(this.tableInfo, null, null).stream().collect(Collectors.toMap(SegmentMetadata::getPath, Function.identity()));
        }
        return this.segmentsMetadata;
    }

    public FileMetadata getFileMetadata(Path location) {
        this.throwIfChanged();
        return this.basicTablesRequests.fileMetadata(this.tableInfo, null, location.toUri().getPath());
    }

    public List<FileMetadata> getFilesForPartition(PartitionMetadata partition) {
        this.throwIfChanged();
        List paths = partition.getLocations().stream().map(path -> path.toUri().getPath()).collect(Collectors.toList());
        return this.basicTablesRequests.filesMetadata(this.tableInfo, null, paths);
    }

    public NonInterestingColumnsMetadata getNonInterestingColumnsMetadata() {
        this.throwIfChanged();
        if (this.nonInterestingColumnsMetadata == null) {
            TupleMetadata schema = this.getTableMetadata().getSchema();
            List<StatisticsHolder> statistics = Collections.singletonList(new StatisticsHolder((Object)-1L, (BaseStatisticsKind)ColumnStatisticsKind.NULLS_COUNT));
            List<SchemaPath> columnPaths = SchemaUtil.getSchemaPaths(schema);
            List<SchemaPath> interestingColumns = this.getInterestingColumns(columnPaths);
            Map columnsStatistics = columnPaths.stream().filter(schemaPath -> !interestingColumns.contains(schemaPath) || SchemaPathUtils.getColumnMetadata((SchemaPath)schemaPath, (TupleMetadata)schema).isArray()).collect(Collectors.toMap(Function.identity(), schemaPath -> new ColumnStatistics((Collection)statistics, SchemaPathUtils.getColumnMetadata((SchemaPath)schemaPath, (TupleMetadata)schema).type())));
            this.nonInterestingColumnsMetadata = new NonInterestingColumnsMetadata(columnsStatistics);
        }
        return this.nonInterestingColumnsMetadata;
    }

    public boolean checkMetadataVersion() {
        return true;
    }

    private List<SchemaPath> getInterestingColumns(List<SchemaPath> columnPaths) {
        if (this.useStatistics) {
            return this.getTableMetadata().getInterestingColumns() == null ? columnPaths : this.getTableMetadata().getInterestingColumns();
        }
        return Collections.emptyList();
    }

    public static class Builder<T extends Builder<T>>
    implements FileTableMetadataProviderBuilder<T> {
        protected final MetastoreMetadataProviderManager metadataProviderManager;
        protected final TableMetadataProviderBuilder fallback;
        protected TupleMetadata schema;
        protected List<String> paths;
        private FileSelection selection;
        private DrillFileSystem fs;

        public Builder(MetastoreMetadataProviderManager source) {
            this(source, new SimpleFileTableMetadataProvider.Builder(FileSystemMetadataProviderManager.init()));
        }

        protected Builder(MetastoreMetadataProviderManager source, TableMetadataProviderBuilder fallback) {
            this.metadataProviderManager = source;
            this.fallback = fallback;
        }

        public T withSchema(TupleMetadata schema) {
            this.schema = schema;
            return this.self();
        }

        @Override
        public T withSelection(FileSelection selection) {
            this.selection = selection;
            return this.self();
        }

        @Override
        public T withFileSystem(DrillFileSystem fs) {
            this.fs = fs;
            return this.self();
        }

        protected T self() {
            return (T)this;
        }

        public MetastoreMetadataProviderManager metadataProviderManager() {
            return this.metadataProviderManager;
        }

        public FileSelection selection() {
            return this.selection;
        }

        public DrillFileSystem fs() {
            return this.fs;
        }

        public TableMetadataProvider build() throws IOException {
            this.paths = this.selection().isExpandedFully() ? this.selection.getFiles().stream().map(path -> Path.getPathWithoutSchemeAndAuthority((Path)path).toUri().getPath()).collect(Collectors.toList()) : DrillFileSystemUtil.listFiles((FileSystem)this.fs, this.selection.getSelectionRoot(), true, new PathFilter[0]).stream().map(fileStatus -> Path.getPathWithoutSchemeAndAuthority((Path)fileStatus.getPath()).toUri().getPath()).collect(Collectors.toList());
            return new MetastoreFileTableMetadataProvider(this);
        }
    }
}

