/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.dotdrill;

import java.io.IOException;
import java.io.InputStream;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.exec.dotdrill.DotDrillType;
import oadd.org.apache.drill.exec.dotdrill.View;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;

public class DotDrillFile {
    private final FileStatus status;
    private final DotDrillType type;
    private final DrillFileSystem fs;

    public static DotDrillFile create(DrillFileSystem fs, FileStatus status) {
        for (DotDrillType d : DotDrillType.values()) {
            if (status.isDirectory() || !d.matches(status)) continue;
            return new DotDrillFile(fs, status, d);
        }
        return null;
    }

    private DotDrillFile(DrillFileSystem fs, FileStatus status, DotDrillType type) {
        this.fs = fs;
        this.status = status;
        this.type = type;
    }

    public DotDrillType getType() {
        return this.type;
    }

    public String getOwner() {
        if (this.type == DotDrillType.VIEW && this.status.getOwner().isEmpty()) {
            return ImpersonationUtil.getProcessUserName();
        }
        return this.status.getOwner();
    }

    public String getBaseName() {
        String fileName = this.status.getPath().getName();
        return fileName.substring(0, fileName.lastIndexOf(this.type.getEnding()));
    }

    public View getView(ObjectMapper mapper) throws IOException {
        Preconditions.checkArgument(this.type == DotDrillType.VIEW);
        try (FSDataInputStream is = this.fs.open(this.status.getPath());){
            View view = mapper.readValue((InputStream)is, View.class);
            return view;
        }
    }
}

