/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression.visitors;

import oadd.org.apache.drill.common.expression.AnyValueExpression;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.ErrorCollector;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.IfExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.NullExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedFieldExpr;
import oadd.org.apache.drill.common.expression.TypedNullConstant;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.visitors.AggregateChecker;
import oadd.org.apache.drill.common.expression.visitors.ConstantChecker;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;

public class ExpressionValidator
implements ExprVisitor<Void, ErrorCollector, RuntimeException> {
    @Override
    public Void visitFunctionCall(FunctionCall call, ErrorCollector errors) throws RuntimeException {
        throw new UnsupportedOperationException("FunctionCall is not expected here. It should have been converted to FunctionHolderExpression in materialization");
    }

    @Override
    public Void visitFunctionHolderExpression(FunctionHolderExpression holder, ErrorCollector errors) throws RuntimeException {
        AggregateChecker.isAggregating(holder, errors);
        ConstantChecker.checkConstants(holder, errors);
        return null;
    }

    @Override
    public Void visitBooleanOperator(BooleanOperator op, ErrorCollector errors) throws RuntimeException {
        int i = 0;
        for (LogicalExpression arg : op.args()) {
            if (arg.getMajorType().getMinorType() != TypeProtos.MinorType.BIT) {
                errors.addGeneralError(arg.getPosition(), String.format("Failure composing boolean operator %s.  All conditions must return a boolean type.  Condition %d was of Type %s.", op.getName(), i, arg.getMajorType().getMinorType()));
            }
            ++i;
        }
        return null;
    }

    @Override
    public Void visitIfExpression(IfExpression ifExpr, ErrorCollector errors) throws RuntimeException {
        IfExpression.IfCondition cond = ifExpr.ifCondition;
        TypeProtos.MajorType majorType = cond.condition.getMajorType();
        if (majorType.getMinorType() != TypeProtos.MinorType.BIT) {
            errors.addGeneralError(cond.condition.getPosition(), String.format("Failure composing If Expression.  All conditions must return a boolean type.  Condition was of Type %s.", majorType.getMinorType()));
        }
        TypeProtos.MajorType mt = ifExpr.elseExpression.getMajorType();
        cond = ifExpr.ifCondition;
        TypeProtos.MajorType innerT = cond.expression.getMajorType();
        if (innerT.getMode() == TypeProtos.DataMode.REPEATED && mt.getMode() != TypeProtos.DataMode.REPEATED || innerT.getMinorType() != mt.getMinorType() && innerT.getMode() != TypeProtos.DataMode.OPTIONAL && mt.getMode() != TypeProtos.DataMode.OPTIONAL && innerT.getMinorType() != TypeProtos.MinorType.NULL && mt.getMinorType() != TypeProtos.MinorType.NULL) {
            errors.addGeneralError(cond.condition.getPosition(), String.format("Failure composing If Expression.  All expressions must return the same MinorType as the else expression.  The if condition returned type type %s but the else expression was of type %s", innerT, mt));
        }
        return null;
    }

    @Override
    public Void visitSchemaPath(SchemaPath path, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitIntConstant(ValueExpressions.IntExpression intExpr, ErrorCollector value) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitFloatConstant(ValueExpressions.FloatExpression fExpr, ErrorCollector value) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitLongConstant(ValueExpressions.LongExpression intExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitVarDecimalConstant(ValueExpressions.VarDecimalExpression decExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitDateConstant(ValueExpressions.DateExpression intExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitTimeConstant(ValueExpressions.TimeExpression intExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitIntervalYearConstant(ValueExpressions.IntervalYearExpression intExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitIntervalDayConstant(ValueExpressions.IntervalDayExpression intExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitTimeStampConstant(ValueExpressions.TimeStampExpression intExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitBooleanConstant(ValueExpressions.BooleanExpression e, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitQuotedStringConstant(ValueExpressions.QuotedString e, ErrorCollector errors) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitUnknown(LogicalExpression e, ErrorCollector value) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitCastExpression(CastExpression e, ErrorCollector value) throws RuntimeException {
        return e.getInput().accept(this, value);
    }

    @Override
    public Void visitNullConstant(TypedNullConstant e, ErrorCollector value) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitNullExpression(NullExpression e, ErrorCollector value) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitConvertExpression(ConvertExpression e, ErrorCollector value) throws RuntimeException {
        return e.getInput().accept(this, value);
    }

    @Override
    public Void visitAnyValueExpression(AnyValueExpression e, ErrorCollector value) throws RuntimeException {
        return e.getInput().accept(this, value);
    }

    @Override
    public Void visitParameter(ValueExpressions.ParameterExpression e, ErrorCollector value) throws RuntimeException {
        return null;
    }

    @Override
    public Void visitTypedFieldExpr(TypedFieldExpr e, ErrorCollector value) throws RuntimeException {
        return null;
    }
}

