/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.math.analysis.interpolation;

import oadd.org.apache.commons.math.analysis.interpolation.UnivariateRealInterpolator;
import oadd.org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import oadd.org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import oadd.org.apache.commons.math.exception.DimensionMismatchException;
import oadd.org.apache.commons.math.exception.NumberIsTooSmallException;
import oadd.org.apache.commons.math.exception.util.Localizable;
import oadd.org.apache.commons.math.exception.util.LocalizedFormats;
import oadd.org.apache.commons.math.util.MathUtils;

public class LinearInterpolator
implements UnivariateRealInterpolator {
    public PolynomialSplineFunction interpolate(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new DimensionMismatchException(x.length, y.length);
        }
        if (x.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)x.length, (Number)2, true);
        }
        int n = x.length - 1;
        MathUtils.checkOrder(x);
        double[] m4 = new double[n];
        for (int i = 0; i < n; ++i) {
            m4[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[2];
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = m4[i];
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x, polynomials);
    }
}

