/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.jdbc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import oadd.org.apache.calcite.DataContext;
import oadd.org.apache.calcite.jdbc.CalciteSchema;
import oadd.org.apache.calcite.jdbc.DynamicSchema;
import oadd.org.apache.calcite.linq4j.tree.Expression;
import oadd.org.apache.calcite.linq4j.tree.Expressions;
import oadd.org.apache.calcite.schema.Schema;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.calcite.util.BuiltInMethod;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.exceptions.UserExceptionUtils;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.alias.AliasRegistryProvider;
import oadd.org.apache.drill.exec.planner.sql.SchemaUtilites;
import oadd.org.apache.drill.exec.store.AbstractSchema;
import oadd.org.apache.drill.exec.store.SchemaConfig;
import oadd.org.apache.drill.exec.store.StoragePlugin;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.SubSchemaWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRootSchema
extends DynamicSchema {
    private static final Logger logger = LoggerFactory.getLogger(DynamicRootSchema.class);
    private static final String ROOT_SCHEMA_NAME = "";
    private final SchemaConfig schemaConfig;
    private final StoragePluginRegistry storages;
    private final AliasRegistryProvider aliasRegistryProvider;

    DynamicRootSchema(StoragePluginRegistry storages, SchemaConfig schemaConfig, AliasRegistryProvider aliasRegistryProvider) {
        super(null, (Schema)new RootSchema(storages), ROOT_SCHEMA_NAME);
        this.schemaConfig = schemaConfig;
        this.storages = storages;
        this.aliasRegistryProvider = aliasRegistryProvider;
    }

    @Override
    protected CalciteSchema getImplicitSubSchema(String schemaName, boolean caseSensitive) {
        String actualSchemaName = this.aliasRegistryProvider.getStorageAliasesRegistry().getUserAliases(this.schemaConfig.getUserName()).get(SchemaPath.getSimplePath(schemaName).toExpr());
        return this.getSchema(actualSchemaName != null ? SchemaPath.parseFromString(actualSchemaName).getRootSegmentPath() : schemaName, caseSensitive);
    }

    private CalciteSchema getSchema(String schemaName, boolean caseSensitive) {
        schemaName = schemaName == null ? null : schemaName.toLowerCase();
        CalciteSchema retSchema = (CalciteSchema)this.subSchemaMap.map().get(schemaName);
        if (retSchema != null) {
            return retSchema;
        }
        this.loadSchemaFactory(schemaName, caseSensitive);
        retSchema = (CalciteSchema)this.subSchemaMap.map().get(schemaName);
        return retSchema;
    }

    public SchemaPath resolveTableAlias(String alias) {
        return Optional.ofNullable(this.aliasRegistryProvider.getTableAliasesRegistry().getUserAliases(this.schemaConfig.getUserName()).get(alias)).map(SchemaPath::parseFromString).orElse(null);
    }

    private void loadSchemaFactory(String schemaName, boolean caseSensitive) {
        block9: {
            try {
                SchemaPlus schemaPlus = this.plus();
                StoragePlugin plugin = this.storages.getPlugin(schemaName);
                if (plugin != null) {
                    plugin.registerSchemas(this.schemaConfig, schemaPlus);
                    return;
                }
                List paths = SchemaUtilites.getSchemaPathAsList((String)schemaName);
                if (paths.size() != 2) break block9;
                plugin = this.storages.getPlugin((String)paths.get(0));
                if (plugin == null) {
                    return;
                }
                SchemaPlus firstLevelSchema = schemaPlus.getSubSchema((String)paths.get(0));
                if (firstLevelSchema == null) {
                    plugin.registerSchemas(this.schemaConfig, schemaPlus);
                    firstLevelSchema = schemaPlus.getSubSchema((String)paths.get(0));
                }
                ArrayList<SchemaPlus> secondLevelSchemas = new ArrayList<SchemaPlus>();
                for (String secondLevelSchemaName : firstLevelSchema.getSubSchemaNames()) {
                    secondLevelSchemas.add(firstLevelSchema.getSubSchema(secondLevelSchemaName));
                }
                for (SchemaPlus schema : secondLevelSchemas) {
                    AbstractSchema drillSchema;
                    try {
                        drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException(String.format("Schema '%s' is not expected under root schema", schema.getName()));
                    }
                    SubSchemaWrapper wrapper = new SubSchemaWrapper(drillSchema);
                    schemaPlus.add(wrapper.getName(), (Schema)wrapper);
                }
            }
            catch (IOException | StoragePluginRegistry.PluginException ex) {
                logger.warn("Failed to load schema for \"" + schemaName + "\"!", ex);
                UserException.Builder exceptBuilder = UserException.resourceError(ex).message("Failed to load schema for \"" + schemaName + "\"!", new Object[0]).addContext(ex.getClass().getName() + ": " + ex.getMessage()).addContext(UserExceptionUtils.getUserHint(ex));
                throw exceptBuilder.build(logger);
            }
        }
    }

    public static class RootSchema
    extends AbstractSchema {
        private StoragePluginRegistry storages;

        public RootSchema(StoragePluginRegistry storages) {
            super(Collections.emptyList(), DynamicRootSchema.ROOT_SCHEMA_NAME);
            this.storages = storages;
        }

        public Set<String> getSubSchemaNames() {
            return this.storages.availablePlugins();
        }

        public String getTypeName() {
            return DynamicRootSchema.ROOT_SCHEMA_NAME;
        }

        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, (Expression[])new Expression[0]);
        }

        public boolean showInInformationSchema() {
            return false;
        }
    }
}

