/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.netty.handler.codec;

import java.util.List;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.handler.codec.ByteToMessageDecoder;
import oadd.io.netty.util.internal.ObjectUtil;

public class FixedLengthFrameDecoder
extends ByteToMessageDecoder {
    private final int frameLength;

    public FixedLengthFrameDecoder(int frameLength) {
        ObjectUtil.checkPositive(frameLength, "frameLength");
        this.frameLength = frameLength;
    }

    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Object decoded = this.decode(ctx, in);
        if (decoded != null) {
            out.add(decoded);
        }
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (in.readableBytes() < this.frameLength) {
            return null;
        }
        return in.readRetainedSlice(this.frameLength);
    }
}

