/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.io;

import java.io.IOException;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.io.jsonwebtoken.io.DeserializationException;
import oadd.io.jsonwebtoken.io.Deserializer;
import oadd.io.jsonwebtoken.io.JacksonSerializer;
import oadd.io.jsonwebtoken.lang.Assert;

public class JacksonDeserializer<T>
implements Deserializer<T> {
    private final Class<T> returnType;
    private final ObjectMapper objectMapper;

    public JacksonDeserializer() {
        this(JacksonSerializer.DEFAULT_OBJECT_MAPPER);
    }

    public JacksonDeserializer(ObjectMapper objectMapper) {
        this(objectMapper, Object.class);
    }

    private JacksonDeserializer(ObjectMapper objectMapper, Class<T> returnType) {
        Assert.notNull(objectMapper, "ObjectMapper cannot be null.");
        Assert.notNull(returnType, "Return type cannot be null.");
        this.objectMapper = objectMapper;
        this.returnType = returnType;
    }

    @Override
    public T deserialize(byte[] bytes) throws DeserializationException {
        try {
            return this.readValue(bytes);
        }
        catch (IOException e) {
            String msg = "Unable to deserialize bytes into a " + this.returnType.getName() + " instance: " + e.getMessage();
            throw new DeserializationException(msg, e);
        }
    }

    protected T readValue(byte[] bytes) throws IOException {
        return this.objectMapper.readValue(bytes, this.returnType);
    }
}

