/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.impl.crypto;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAKey;
import oadd.io.jsonwebtoken.SignatureAlgorithm;
import oadd.io.jsonwebtoken.impl.crypto.RsaProvider;
import oadd.io.jsonwebtoken.impl.crypto.Signer;

public class RsaSigner
extends RsaProvider
implements Signer {
    public RsaSigner(SignatureAlgorithm alg, Key key) {
        super(alg, key);
        if (!(key instanceof PrivateKey) || !(key instanceof RSAKey)) {
            String msg = "RSA signatures must be computed using an RSA PrivateKey.  The specified key of type " + key.getClass().getName() + " is not an RSA PrivateKey.";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public byte[] sign(byte[] data) {
        try {
            return this.doSign(data);
        }
        catch (InvalidKeyException e) {
            throw new oadd.io.jsonwebtoken.security.SignatureException("Invalid RSA PrivateKey. " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new oadd.io.jsonwebtoken.security.SignatureException("Unable to calculate signature using RSA PrivateKey. " + e.getMessage(), e);
        }
    }

    protected byte[] doSign(byte[] data) throws InvalidKeyException, SignatureException {
        PrivateKey privateKey = (PrivateKey)this.key;
        Signature sig = this.createSignatureInstance();
        sig.initSign(privateKey);
        sig.update(data);
        return sig.sign();
    }
}

