/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import oadd.com.carrotsearch.hppc.ArraySizingStrategy;
import oadd.com.carrotsearch.hppc.FloatArrayList;
import oadd.com.carrotsearch.hppc.FloatContainer;
import oadd.com.carrotsearch.hppc.cursors.FloatCursor;

public class FloatStack
extends FloatArrayList {
    public FloatStack() {
    }

    public FloatStack(int expectedElements) {
        super(expectedElements);
    }

    public FloatStack(int expectedElements, ArraySizingStrategy resizer) {
        super(expectedElements, resizer);
    }

    public FloatStack(FloatContainer container) {
        super(container);
    }

    public void push(float e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void push(float e1, float e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void push(float e1, float e2, float e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void push(float e1, float e2, float e3, float e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void push(float[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(float ... elements) {
        this.push(elements, 0, elements.length);
    }

    public int pushAll(FloatContainer container) {
        return this.addAll(container);
    }

    public int pushAll(Iterable<? extends FloatCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public float pop() {
        assert (this.elementsCount > 0);
        float v = this.buffer[--this.elementsCount];
        return v;
    }

    public float peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static FloatStack from(float ... elements) {
        FloatStack stack = new FloatStack(elements.length);
        stack.push(elements);
        return stack;
    }

    @Override
    public FloatStack clone() {
        return (FloatStack)super.clone();
    }
}

