/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.AlgorithmDecomposer;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAlgorithmConstraints
implements BCAlgorithmConstraints {
    protected final AlgorithmDecomposer decomposer;

    AbstractAlgorithmConstraints(AlgorithmDecomposer decomposer) {
        this.decomposer = decomposer;
    }

    protected void checkAlgorithmName(String algorithm) {
        if (!JsseUtils.isNameSpecified(algorithm)) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
    }

    protected void checkKey(Key key) {
        if (null == key) {
            throw new NullPointerException("'key' cannot be null");
        }
    }

    protected void checkPrimitives(Set<BCCryptoPrimitive> primitives) {
        if (!this.isPrimitivesSpecified(primitives)) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
    }

    protected boolean containsAnyPartIgnoreCase(Set<String> elements, String algorithm) {
        if (elements.isEmpty()) {
            return false;
        }
        if (this.containsIgnoreCase(elements, algorithm)) {
            return true;
        }
        if (null != this.decomposer) {
            for (String part : this.decomposer.decompose(algorithm)) {
                if (!this.containsIgnoreCase(elements, part)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean containsIgnoreCase(Set<String> elements, String s2) {
        for (String element : elements) {
            if (!element.equalsIgnoreCase(s2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPrimitivesSpecified(Set<BCCryptoPrimitive> primitives) {
        return null != primitives && !primitives.isEmpty();
    }

    protected static Set<String> asUnmodifiableSet(String[] algorithms) {
        Set<String> result;
        if (null != algorithms && algorithms.length > 0 && !(result = AbstractAlgorithmConstraints.asSet(algorithms)).isEmpty()) {
            return Collections.unmodifiableSet(result);
        }
        return Collections.emptySet();
    }

    protected static Set<String> asSet(String[] algorithms) {
        HashSet<String> result = new HashSet<String>();
        if (null != algorithms) {
            for (String algorithm : algorithms) {
                if (null == algorithm) continue;
                result.add(algorithm);
            }
        }
        return result;
    }
}

