/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.Properties;
import java.util.TimeZone;
import oadd.org.apache.calcite.avatica.AvaticaConnection;
import oadd.org.apache.calcite.avatica.AvaticaFactory;
import oadd.org.apache.calcite.avatica.AvaticaStatement;
import oadd.org.apache.calcite.avatica.Helper;
import oadd.org.apache.calcite.avatica.Meta;
import oadd.org.apache.calcite.avatica.QueryState;
import oadd.org.apache.drill.exec.client.DrillClient;
import oadd.org.apache.drill.exec.client.ServerMethod;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillDatabaseMetaDataImpl;
import org.apache.drill.jdbc.impl.DrillFactory;
import org.apache.drill.jdbc.impl.DrillPreparedStatementImpl;
import org.apache.drill.jdbc.impl.DrillResultSetImpl;
import org.apache.drill.jdbc.impl.DrillResultSetMetaDataImpl;
import org.apache.drill.jdbc.impl.DrillStatementImpl;
import org.apache.drill.jdbc.impl.DriverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillJdbc41Factory
extends DrillFactory {
    private static final Logger logger = LoggerFactory.getLogger(DrillJdbc41Factory.class);

    public DrillJdbc41Factory() {
        this(4, 1);
    }

    protected DrillJdbc41Factory(int major, int minor) {
        super(major, minor);
    }

    @Override
    DrillConnectionImpl newDrillConnection(DriverImpl driver, DrillFactory factory, String url, Properties info) throws SQLException {
        return new DrillConnectionImpl(driver, (AvaticaFactory)factory, url, info);
    }

    @Override
    public DrillDatabaseMetaDataImpl newDatabaseMetaData(AvaticaConnection connection) {
        return new DrillDatabaseMetaDataImpl((DrillConnectionImpl)connection);
    }

    @Override
    public DrillStatementImpl newStatement(AvaticaConnection connection, Meta.StatementHandle h2, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new DrillStatementImpl((DrillConnectionImpl)connection, h2, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public DrillJdbc41PreparedStatement newPreparedStatement(AvaticaConnection connection, Meta.StatementHandle h2, Meta.Signature signature, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DrillConnectionImpl drillConnection = (DrillConnectionImpl)connection;
        DrillClient client = drillConnection.getClient();
        if (drillConnection.getConfig().isServerPreparedStatementDisabled() || !client.getSupportedMethods().contains((Object)ServerMethod.PREPARED_STATEMENT)) {
            return new DrillJdbc41PreparedStatement(drillConnection, h2, signature, null, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return this.newServerPreparedStatement(drillConnection, h2, signature, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    private DrillJdbc41PreparedStatement newServerPreparedStatement(DrillConnectionImpl connection, Meta.StatementHandle h2, Meta.Signature signature, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String sql = signature.sql;
        try {
            UserProtos.CreatePreparedStatementResp resp;
            DrillRpcFuture<UserProtos.CreatePreparedStatementResp> respFuture = connection.getClient().createPreparedStatement(signature.sql);
            try {
                resp = (UserProtos.CreatePreparedStatementResp)respFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException("Interrupted", e);
            }
            UserProtos.RequestStatus status = resp.getStatus();
            if (status != UserProtos.RequestStatus.OK) {
                String errMsgFromServer;
                String string = errMsgFromServer = resp.getError() != null ? resp.getError().getMessage() : "";
                if (status == UserProtos.RequestStatus.TIMEOUT) {
                    logger.error("Request timed out to create prepare statement: {}", (Object)errMsgFromServer);
                    throw new SQLTimeoutException("Failed to create prepared statement: " + errMsgFromServer);
                }
                if (status == UserProtos.RequestStatus.FAILED) {
                    logger.error("Failed to create prepared statement: {}", (Object)errMsgFromServer);
                    throw new SQLException("Failed to create prepared statement: " + errMsgFromServer);
                }
                logger.error("Failed to create prepared statement. Unknown status: {}, Error: {}", (Object)status, (Object)errMsgFromServer);
                throw new SQLException(String.format("Failed to create prepared statement. Unknown status: %s, Error: %s", status, errMsgFromServer));
            }
            return new DrillJdbc41PreparedStatement(connection, h2, signature, resp.getPreparedStatement(), resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
    }

    @Override
    public DrillResultSetImpl newResultSet(AvaticaStatement statement, QueryState state, Meta.Signature signature, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        ResultSetMetaData metaData = this.newResultSetMetaData(statement, signature);
        return new DrillResultSetImpl(statement, state, signature, metaData, timeZone, firstFrame);
    }

    @Override
    public ResultSetMetaData newResultSetMetaData(AvaticaStatement statement, Meta.Signature signature) {
        return new DrillResultSetMetaDataImpl(statement, null, signature);
    }

    private static class DrillJdbc41PreparedStatement
    extends DrillPreparedStatementImpl {
        DrillJdbc41PreparedStatement(DrillConnectionImpl connection, Meta.StatementHandle h2, Meta.Signature signature, UserProtos.PreparedStatement pstmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            super(connection, h2, signature, pstmt, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
    }
}

