/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.fn;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.vector.complex.impl.ComplexCopier;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class JsonReaderUtils {
    public static void ensureAtLeastOneField(BaseWriter.ComplexWriter writer, Collection<SchemaPath> columns, boolean allTextMode, List<BaseWriter.ListWriter> emptyArrayWriters) {
        PathSegment fieldPath;
        ArrayList<BaseWriter.MapWriter> writerList = new ArrayList<BaseWriter.MapWriter>();
        ArrayList<PathSegment> fieldPathList = new ArrayList<PathSegment>();
        BitSet emptyWriters = new BitSet(columns.size());
        int fieldIndex = 0;
        for (SchemaPath schemaPath : columns) {
            fieldPath = schemaPath.getRootSegment();
            BaseWriter.MapWriter fieldWriter = writer.rootAsMap();
            while (fieldPath.getChild() != null && !fieldPath.getChild().isArray()) {
                fieldWriter = fieldWriter.map(fieldPath.getNameSegment().getPath());
                fieldPath = fieldPath.getChild();
            }
            writerList.add(fieldWriter);
            fieldPathList.add(fieldPath);
            if (fieldWriter.isEmptyMap()) {
                emptyWriters.set(fieldIndex, true);
            }
            if (fieldIndex == 0 && !allTextMode) break;
            ++fieldIndex;
        }
        for (int j = 0; j < fieldPathList.size(); ++j) {
            BaseWriter.MapWriter fieldWriter = (BaseWriter.MapWriter)writerList.get(j);
            fieldPath = (PathSegment)fieldPathList.get(j);
            if (!emptyWriters.get(j)) continue;
            if (allTextMode) {
                fieldWriter.varChar(fieldPath.getNameSegment().getPath());
                continue;
            }
            fieldWriter.integer(fieldPath.getNameSegment().getPath());
        }
        for (BaseWriter.ListWriter field : emptyArrayWriters) {
            if (field.getValueCapacity() != 0) continue;
            if (allTextMode) {
                field.varChar();
                continue;
            }
            field.integer();
        }
    }

    public static void writeColumnsUsingSchema(BaseWriter.ComplexWriter writer, Collection<SchemaPath> columns, TupleMetadata schema, boolean allTextMode) {
        BaseWriter.MapWriter mapWriter = writer.rootAsMap();
        for (SchemaPath column : columns) {
            if (column.isDynamicStar()) {
                JsonReaderUtils.writeSchemaColumns(schema, mapWriter, allTextMode);
                continue;
            }
            ColumnMetadata columnMetadata = schema.metadata(column.getRootSegmentPath());
            JsonReaderUtils.writeColumnToMapWriter(mapWriter, column.getRootSegment(), columnMetadata, allTextMode);
        }
    }

    private static void writeColumnToMapWriter(BaseWriter.MapWriter writer, PathSegment column, ColumnMetadata columnMetadata, boolean allTextMode) {
        PathSegment child = column.getChild();
        if (child != null && child.isNamed()) {
            String name = column.getNameSegment().getPath();
            ColumnMetadata childMetadata = columnMetadata.tupleSchema().metadata(name);
            JsonReaderUtils.writeColumnToMapWriter(writer.map(name), child, childMetadata, allTextMode);
        } else {
            JsonReaderUtils.writeSingleOrArrayColumn(columnMetadata, writer, allTextMode);
        }
    }

    private static void writeSingleOrArrayColumn(ColumnMetadata columnMetadata, BaseWriter.MapWriter writer, boolean allTextMode) {
        if (columnMetadata.isArray()) {
            JsonReaderUtils.writeArrayColumn(columnMetadata, writer.list(columnMetadata.name()), allTextMode);
        } else {
            JsonReaderUtils.writeColumn(columnMetadata, writer, allTextMode);
        }
    }

    private static void writeSchemaColumns(TupleMetadata schema, BaseWriter.MapWriter fieldWriter, boolean allTextMode) {
        for (ColumnMetadata columnMetadata : schema) {
            JsonReaderUtils.writeSingleOrArrayColumn(columnMetadata, fieldWriter, allTextMode);
        }
    }

    private static void writeColumn(ColumnMetadata columnMetadata, BaseWriter.MapWriter fieldWriter, boolean allTextMode) {
        switch (columnMetadata.structureType()) {
            case DICT: {
                JsonReaderUtils.writeSchemaColumns(columnMetadata.tupleSchema(), fieldWriter.dict(columnMetadata.name()), allTextMode);
                break;
            }
            case TUPLE: {
                JsonReaderUtils.writeSchemaColumns(columnMetadata.tupleSchema(), fieldWriter.map(columnMetadata.name()), allTextMode);
                break;
            }
            case MULTI_ARRAY: {
                JsonReaderUtils.writeArrayColumn(columnMetadata.childSchema(), fieldWriter.list(columnMetadata.name()), allTextMode);
                break;
            }
            case PRIMITIVE: {
                if (allTextMode) {
                    fieldWriter.varChar(columnMetadata.name());
                    break;
                }
                ComplexCopier.getMapWriterForType(columnMetadata.majorType(), fieldWriter, columnMetadata.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported type [%s] for column [%s].", columnMetadata.majorType(), columnMetadata.name()));
            }
        }
    }

    private static void writeArrayColumn(ColumnMetadata columnMetadata, BaseWriter.ListWriter fieldWriter, boolean allTextMode) {
        switch (columnMetadata.structureType()) {
            case DICT: {
                JsonReaderUtils.writeSchemaColumns(columnMetadata.tupleSchema(), fieldWriter.dict(), allTextMode);
                break;
            }
            case TUPLE: {
                JsonReaderUtils.writeSchemaColumns(columnMetadata.tupleSchema(), fieldWriter.map(), allTextMode);
                break;
            }
            case MULTI_ARRAY: {
                JsonReaderUtils.writeArrayColumn(columnMetadata.childSchema(), fieldWriter.list(), allTextMode);
                break;
            }
            case PRIMITIVE: {
                if (allTextMode) {
                    fieldWriter.varChar();
                    break;
                }
                ComplexCopier.getListWriterForType(columnMetadata.majorType(), fieldWriter);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported type [%s] for column [%s].", columnMetadata.majorType(), columnMetadata.name()));
            }
        }
    }
}

