/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.accessor.ArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.ObjectArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import oadd.org.apache.drill.exec.vector.complex.RepeatedListVector;

public class RepeatedListWriter
extends ObjectArrayWriter {
    private WriterEvents.State state = WriterEvents.State.IDLE;
    private ArrayListener listener;

    protected RepeatedListWriter(ColumnMetadata schema, UInt4Vector offsetVector, AbstractObjectWriter elementWriter) {
        super(schema, offsetVector, elementWriter);
    }

    public static AbstractObjectWriter buildRepeatedList(ColumnMetadata schema, RepeatedListVector vector, AbstractObjectWriter elementWriter) {
        RepeatedListWriter arrayWriter = new RepeatedListWriter(schema, vector.getOffsetVector(), elementWriter);
        return new AbstractArrayWriter.ArrayObjectWriter(arrayWriter);
    }

    public void bindListener(ArrayListener listener) {
        this.listener = listener;
    }

    public AbstractObjectWriter defineElement(MaterializedField schema) {
        if (this.listener == null || this.elementObjWriter.schema().type() != TypeProtos.MinorType.NULL) {
            throw new UnsupportedOperationException();
        }
        return this.replaceChild(this.listener.setChild((ArrayWriter)this, schema));
    }

    public AbstractObjectWriter defineElement(ColumnMetadata schema) {
        if (this.listener == null || this.elementObjWriter.schema().type() != TypeProtos.MinorType.NULL) {
            throw new UnsupportedOperationException();
        }
        return this.replaceChild(this.listener.setChild((ArrayWriter)this, schema));
    }

    private AbstractObjectWriter replaceChild(AbstractObjectWriter newChild) {
        this.elementObjWriter = newChild;
        this.elementObjWriter.events().bindIndex(this.elementIndex);
        if (this.state != WriterEvents.State.IDLE) {
            this.elementObjWriter.events().startWrite();
            if (this.state == WriterEvents.State.IN_ROW) {
                this.elementObjWriter.events().startRow();
            }
        }
        return this.elementObjWriter;
    }

    @Override
    public void startWrite() {
        assert (this.state == WriterEvents.State.IDLE);
        this.state = WriterEvents.State.IN_WRITE;
        super.startWrite();
    }

    @Override
    public void startRow() {
        assert (this.state == WriterEvents.State.IN_WRITE);
        this.state = WriterEvents.State.IN_ROW;
        super.startRow();
    }

    @Override
    public void saveRow() {
        assert (this.state == WriterEvents.State.IN_ROW);
        super.saveRow();
        this.state = WriterEvents.State.IN_WRITE;
    }

    @Override
    public void endWrite() {
        assert (this.state != WriterEvents.State.IDLE);
        super.endWrite();
        this.state = WriterEvents.State.IDLE;
    }

    public static interface ArrayListener {
        public AbstractObjectWriter setChild(ArrayWriter var1, ColumnMetadata var2);

        public AbstractObjectWriter setChild(ArrayWriter var1, MaterializedField var2);
    }
}

