/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.UnsupportedConversionError;
import oadd.org.apache.drill.exec.vector.accessor.ValueType;
import oadd.org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import oadd.org.joda.time.Period;

public abstract class AbstractScalarWriter
implements ScalarWriter {
    @Override
    public ValueType extendedType() {
        return this.valueType();
    }

    @Override
    public void setObject(Object value) {
        if (value == null) {
            this.setNull();
        } else if (value instanceof Integer) {
            this.setInt((Integer)value);
        } else if (value instanceof Long) {
            this.setLong((Long)value);
        } else if (value instanceof String) {
            this.setString((String)value);
        } else if (value instanceof Double) {
            this.setDouble((Double)value);
        } else if (value instanceof Float) {
            this.setFloat(((Float)value).floatValue());
        } else if (value instanceof BigDecimal) {
            this.setDecimal((BigDecimal)value);
        } else if (value instanceof Period) {
            this.setPeriod((Period)value);
        } else if (value instanceof LocalTime) {
            this.setTime((LocalTime)value);
        } else if (value instanceof LocalDate) {
            this.setDate((LocalDate)value);
        } else if (value instanceof Instant) {
            this.setTimestamp((Instant)value);
        } else if (value instanceof Date) {
            this.setTimestamp(Instant.ofEpochMilli(((Date)value).getTime()));
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            this.setBytes(bytes, bytes.length);
        } else if (value instanceof Byte) {
            this.setInt(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.setInt(((Short)value).shortValue());
        } else if (value instanceof Boolean) {
            this.setBoolean((Boolean)value);
        } else {
            throw this.conversionError(value.getClass().getSimpleName());
        }
    }

    protected UnsupportedConversionError conversionError(String javaType) {
        return UnsupportedConversionError.writeError(this.schema(), javaType);
    }

    public void bindListener(WriterEvents.ColumnWriterListener listener) {
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + this.schema().toString() + ", projected=" + this.isProjected() + "]";
    }
}

