/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.io.InputStream;
import java.io.InputStreamReader;
import oadd.com.google.common.base.Charsets;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import oadd.org.apache.drill.exec.vector.NullableVarCharVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class NullableVarCharAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.VARCHAR);
    private final NullableVarCharVector.Accessor ac;

    public NullableVarCharAccessor(NullableVarCharVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public InputStream getStream(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        NullableVarCharHolder h2 = new NullableVarCharHolder();
        this.ac.get(index, h2);
        return new ByteBufInputStream(h2.buffer.slice(h2.start, h2.end));
    }

    @Override
    public byte[] getBytes(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.get(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return String.class;
    }

    @Override
    public String getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.getString(index);
    }

    @Override
    public InputStreamReader getReader(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return new InputStreamReader(this.getStream(index), Charsets.UTF_8);
    }

    @Override
    public String getString(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return new String(this.getBytes(index), Charsets.UTF_8);
    }
}

