/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.security.plain;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorFactory;
import oadd.org.apache.drill.exec.rpc.security.FastSaslClientFactory;
import oadd.org.apache.drill.exec.rpc.security.SecurityConfiguration;
import oadd.org.apache.drill.exec.rpc.security.plain.PlainServer;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainFactory
implements AuthenticatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(PlainFactory.class);
    public static final String SIMPLE_NAME = "PLAIN";
    private final UserAuthenticator authenticator;

    public PlainFactory() {
        this.authenticator = null;
    }

    public PlainFactory(UserAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public String getSimpleName() {
        return SIMPLE_NAME;
    }

    @Override
    public UserGroupInformation createAndLoginUser(Map<String, ?> properties) throws IOException {
        SecurityConfiguration conf = new SecurityConfiguration();
        conf.set("hadoop.login", "simple");
        UserGroupInformation.setConfiguration((Configuration)conf);
        try {
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            logger.debug("Login failed.", e);
            Throwable cause = e.getCause();
            if (cause instanceof LoginException) {
                throw new SaslException("Failed to login.", cause);
            }
            throw new SaslException("Unexpected failure trying to login. ", cause);
        }
    }

    @Override
    public SaslServer createSaslServer(UserGroupInformation ugi, Map<String, ?> properties) throws SaslException {
        return new PlainServer(this.authenticator, properties);
    }

    @Override
    public SaslClient createSaslClient(UserGroupInformation ugi, Map<String, ?> properties) throws SaslException {
        final String userName = (String)properties.get("user");
        final String password = (String)properties.get("password");
        return FastSaslClientFactory.getInstance().createSaslClient(new String[]{SIMPLE_NAME}, null, null, null, properties, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)NameCallback.class.cast(callback)).setName(userName);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)PasswordCallback.class.cast(callback)).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        if (this.authenticator != null) {
            this.authenticator.close();
        }
    }

    public UserAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

