/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.SchemaBuilder;

public class BatchSchemaBuilder {
    private BatchSchema.SelectionVectorMode svMode = BatchSchema.SelectionVectorMode.NONE;
    private SchemaBuilder schemaBuilder;

    public BatchSchemaBuilder() {
    }

    public BatchSchemaBuilder(BatchSchema baseSchema) {
        this.schemaBuilder = new SchemaBuilder();
        for (MaterializedField field : baseSchema) {
            this.schemaBuilder.add(field);
        }
    }

    public BatchSchemaBuilder withSVMode(BatchSchema.SelectionVectorMode svMode) {
        this.svMode = svMode;
        return this;
    }

    public BatchSchemaBuilder withSchemaBuilder(SchemaBuilder schemaBuilder) {
        this.schemaBuilder = schemaBuilder;
        return this;
    }

    public SchemaBuilder schemaBuilder() {
        return this.schemaBuilder;
    }

    public BatchSchema build() {
        return new BatchSchema(this.svMode, this.schemaBuilder.buildSchema().toFieldList());
    }
}

