/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.BufferManager;
import oadd.org.apache.drill.exec.ops.BufferManagerImpl;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.drill.exec.testing.ControlsInjector;
import oadd.org.apache.drill.exec.testing.ExecutionControls;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOperatorContext
implements OperatorContext {
    static final Logger logger = LoggerFactory.getLogger(BaseOperatorContext.class);
    protected final FragmentContext context;
    protected final BufferAllocator allocator;
    protected final PhysicalOperator popConfig;
    protected final BufferManager manager;
    private List<DrillFileSystem> fileSystems;
    private ControlsInjector injector;
    private boolean allowCreatingFileSystem = true;

    public BaseOperatorContext(FragmentContext context, BufferAllocator allocator, PhysicalOperator popConfig) {
        this.context = context;
        this.allocator = allocator;
        this.popConfig = popConfig;
        this.manager = new BufferManagerImpl(allocator);
        this.fileSystems = new ArrayList<DrillFileSystem>();
    }

    @Override
    public FragmentContext getFragmentContext() {
        return this.context;
    }

    @Override
    public <T extends PhysicalOperator> T getOperatorDefn() {
        return (T)this.popConfig;
    }

    public String getName() {
        return this.popConfig.getClass().getName();
    }

    @Override
    public DrillBuf replace(DrillBuf old, int newSize) {
        return this.manager.replace(old, newSize);
    }

    @Override
    public DrillBuf getManagedBuffer() {
        return this.manager.getManagedBuffer();
    }

    @Override
    public DrillBuf getManagedBuffer(int size) {
        return this.manager.getManagedBuffer(size);
    }

    @Override
    public ExecutionControls getExecutionControls() {
        return this.context.getExecutionControls();
    }

    @Override
    public BufferAllocator getAllocator() {
        if (this.allocator == null) {
            throw new UnsupportedOperationException("Operator context does not have an allocator");
        }
        return this.allocator;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.context.getExecutor();
    }

    @Override
    public ExecutorService getScanExecutor() {
        return this.context.getScanExecutor();
    }

    @Override
    public ExecutorService getScanDecodeExecutor() {
        return this.context.getScanDecodeExecutor();
    }

    @Override
    public void setInjector(ControlsInjector injector) {
        this.injector = injector;
    }

    @Override
    public ControlsInjector getInjector() {
        return this.injector;
    }

    @Override
    public void injectUnchecked(String desc) {
        ExecutionControls executionControls = this.context.getExecutionControls();
        if (this.injector != null && executionControls != null) {
            this.injector.injectUnchecked(executionControls, desc);
        }
    }

    @Override
    public <T extends Throwable> void injectChecked(String desc, Class<T> exceptionClass) throws T {
        ExecutionControls executionControls = this.context.getExecutionControls();
        if (this.injector != null && executionControls != null) {
            this.injector.injectChecked(executionControls, desc, exceptionClass);
        }
    }

    @Override
    public void close() {
        RuntimeException ex = null;
        try {
            this.manager.close();
        }
        catch (RuntimeException e) {
            ex = e;
        }
        try {
            if (this.allocator != null) {
                this.allocator.close();
            }
        }
        catch (RuntimeException e) {
            ex = ex == null ? e : ex;
        }
        for (DrillFileSystem fs : this.fileSystems) {
            try {
                fs.close();
            }
            catch (IOException e) {
                throw UserException.resourceError(e).addContext("Failed to close the Drill file system for " + this.getName()).build(logger);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public DrillFileSystem newFileSystem(Configuration conf) throws IOException {
        Preconditions.checkState(this.allowCreatingFileSystem, "Only one tracking file system is allowed per Operator Context and it is already created.");
        Preconditions.checkState(this.fileSystems.isEmpty(), "Non-tracking file system(-s) is(are) already created.");
        DrillFileSystem fs = new DrillFileSystem(conf, this.getStats());
        this.fileSystems.add(fs);
        this.allowCreatingFileSystem = false;
        return fs;
    }

    @Override
    public DrillFileSystem newNonTrackingFileSystem(Configuration conf) throws IOException {
        Preconditions.checkState(this.allowCreatingFileSystem, "Only one tracking file system is allowed per Operator Context and it is already created.");
        DrillFileSystem fs = new DrillFileSystem(conf, null);
        this.fileSystems.add(fs);
        return fs;
    }
}

