/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.local;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.exec.coord.store.BaseTransientStore;
import oadd.org.apache.drill.exec.coord.store.TransientStoreConfig;
import oadd.org.apache.drill.exec.coord.store.TransientStoreEvent;
import oadd.org.apache.drill.exec.coord.store.TransientStoreEventType;

public class MapBackedStore<V>
extends BaseTransientStore<V> {
    private final ConcurrentMap<String, V> delegate = Maps.newConcurrentMap();

    public MapBackedStore(TransientStoreConfig<V> config) {
        super(config);
    }

    @Override
    public V get(String key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(String key, V value) {
        boolean hasKey = this.delegate.containsKey(key);
        V old = this.delegate.put(key, value);
        if (old != value) {
            TransientStoreEventType type = hasKey ? TransientStoreEventType.UPDATE : TransientStoreEventType.CREATE;
            this.fireListeners(TransientStoreEvent.of(type, key, value));
        }
        return old;
    }

    @Override
    public V putIfAbsent(String key, V value) {
        V existing = this.delegate.putIfAbsent(key, value);
        if (existing == null) {
            this.fireListeners(TransientStoreEvent.of(TransientStoreEventType.CREATE, key, value));
        }
        return existing;
    }

    @Override
    public V remove(String key) {
        Object existing = this.delegate.remove(key);
        if (existing != null) {
            this.fireListeners(TransientStoreEvent.of(TransientStoreEventType.DELETE, key, existing));
        }
        return existing;
    }

    @Override
    public Iterator<Map.Entry<String, V>> entries() {
        return this.delegate.entrySet().iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void close() throws Exception {
        this.delegate.clear();
    }
}

