/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.parser;

import oadd.org.antlr.v4.runtime.CharStreams;
import oadd.org.antlr.v4.runtime.CommonTokenStream;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.parser.ExprLexer;
import oadd.org.apache.drill.common.expression.parser.ExprParser;
import oadd.org.apache.drill.common.parser.ErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalExpressionParser {
    private static final Logger logger = LoggerFactory.getLogger(LogicalExpressionParser.class);

    public static LogicalExpression parse(String expr, boolean allowNoIndexArray) {
        ExprLexer lexer = new ExprLexer(CharStreams.fromString(expr));
        lexer.removeErrorListeners();
        lexer.addErrorListener(ErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ExprParser parser = new ExprParser(tokens);
        parser.setAllowArrayWithNoIndex(allowNoIndexArray);
        parser.removeErrorListeners();
        parser.addErrorListener(ErrorListener.INSTANCE);
        ExprParser.ParseContext parseContext = parser.parse();
        logger.trace("Tokens: [{}]. Parsing details: [{}].", (Object)tokens.getText(), (Object)parseContext.toInfoString(parser));
        return parseContext.e;
    }

    public static LogicalExpression parse(String expr) {
        return LogicalExpressionParser.parse(expr, false);
    }
}

