/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression.fn;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.types.TypeProtos;

public class FunctionReplacementUtils {
    private static final Map<TypeProtos.MinorType, String> TYPE_TO_CAST_FUNC = new HashMap<TypeProtos.MinorType, String>();
    private static final Map<String, Set<TypeProtos.MinorType>> FUNC_TO_INPUT_TYPES = new HashMap<String, Set<TypeProtos.MinorType>>();
    private static final Set<String> FUNC_REPLACEMENT_NEEDED = new HashSet<String>();
    private static final Map<String, String> FUNC_REPLACEMENT_FROM_NON_NULLABLE_VARCHAR = new HashMap<String, String>();
    private static final Map<String, String> FUNC_REPLACEMENT_FROM_NON_NULLABLE_VAR16CHAR = new HashMap<String, String>();
    private static final Map<String, String> FUNC_REPLACEMENT_FROM_NON_NULLABLE_VARBINARY = new HashMap<String, String>();
    private static final Map<String, String> FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR = new HashMap<String, String>();
    private static final Map<String, String> FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR = new HashMap<String, String>();
    private static final Map<String, String> FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY = new HashMap<String, String>();

    private static void initCastFunctionSubstitutions() {
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.UNION, "castUNION");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.BIGINT, "castBIGINT");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.INT, "castINT");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.BIT, "castBIT");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.TINYINT, "castTINYINT");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.FLOAT4, "castFLOAT4");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.FLOAT8, "castFLOAT8");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.VARCHAR, "castVARCHAR");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.VAR16CHAR, "castVAR16CHAR");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.VARBINARY, "castVARBINARY");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.DATE, "castDATE");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.TIME, "castTIME");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.TIMESTAMP, "castTIMESTAMP");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.TIMESTAMPTZ, "castTIMESTAMPTZ");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.INTERVALDAY, "castINTERVALDAY");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.INTERVALYEAR, "castINTERVALYEAR");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.INTERVAL, "castINTERVAL");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.DECIMAL9, "castDECIMAL9");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.DECIMAL18, "castDECIMAL18");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.DECIMAL28SPARSE, "castDECIMAL28SPARSE");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.DECIMAL28DENSE, "castDECIMAL28DENSE");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.DECIMAL38SPARSE, "castDECIMAL38SPARSE");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.DECIMAL38DENSE, "castDECIMAL38DENSE");
        TYPE_TO_CAST_FUNC.put(TypeProtos.MinorType.VARDECIMAL, "castVARDECIMAL");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.INT, "NullableINT");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.BIGINT, "NullableBIGINT");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.FLOAT4, "NullableFLOAT4");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.FLOAT8, "NullableFLOAT8");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.DECIMAL9, "NullableDECIMAL9");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.DECIMAL18, "NullableDECIMAL18");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.DECIMAL28SPARSE, "NullableDECIMAL28SPARSE");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.DECIMAL38SPARSE, "NullableDECIMAL38SPARSE");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.VARDECIMAL, "NullableVARDECIMAL");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.DATE, "NULLABLEDATE");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.TIME, "NULLABLETIME");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.TIMESTAMP, "NULLABLETIMESTAMP");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.INTERVAL, "NullableINTERVAL");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.INTERVALDAY, "NullableINTERVALDAY");
        FunctionReplacementUtils.setupReplacementFunctionsForCast(TypeProtos.MinorType.INTERVALYEAR, "NullableINTERVALYEAR");
    }

    private static void initToFunctionSubstitutions() {
        FunctionReplacementUtils.setupReplacementFunctionsForTo("to_number", "ToNumber");
        FunctionReplacementUtils.setupReplacementFunctionsForTo("to_date", "ToNullableDate");
        FunctionReplacementUtils.setupReplacementFunctionsForTo("to_time", "ToNullableTime");
        FunctionReplacementUtils.setupReplacementFunctionsForTo("to_timestamp", "ToNullableTimeStamp");
        FunctionReplacementUtils.setupReplacementFunctionsForTo("sql_to_date", "SqlToNullableDate");
        FunctionReplacementUtils.setupReplacementFunctionsForTo("sql_to_time", "SqlToNullableTime");
        FunctionReplacementUtils.setupReplacementFunctionsForTo("sql_to_timestamp", "SqlToNullableTimeStamp");
    }

    private static void setupReplacementFunctionsForCast(TypeProtos.MinorType type, String toSuffix) {
        String functionName = TYPE_TO_CAST_FUNC.get(type);
        FUNC_REPLACEMENT_NEEDED.add(functionName);
        HashSet<TypeProtos.MinorType> supportedInputTypes = new HashSet<TypeProtos.MinorType>(Arrays.asList(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VAR16CHAR, TypeProtos.MinorType.VARBINARY));
        FUNC_TO_INPUT_TYPES.put(functionName, supportedInputTypes);
        FUNC_REPLACEMENT_FROM_NON_NULLABLE_VARCHAR.put(functionName, "castEmptyStringVarCharTo" + toSuffix);
        FUNC_REPLACEMENT_FROM_NON_NULLABLE_VAR16CHAR.put(functionName, "castEmptyStringVar16CharTo" + toSuffix);
        FUNC_REPLACEMENT_FROM_NON_NULLABLE_VARBINARY.put(functionName, "castEmptyStringVarBinaryTo" + toSuffix);
        FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(functionName, "castEmptyStringNullableVarCharTo" + toSuffix);
        FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.put(functionName, "castEmptyStringNullableVar16CharTo" + toSuffix);
        FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.put(functionName, "castEmptyStringNullableVarBinaryTo" + toSuffix);
    }

    private static void setupReplacementFunctionsForTo(String functionName, String toSuffix) {
        Set<TypeProtos.MinorType> typeSet = Collections.singleton(TypeProtos.MinorType.VARCHAR);
        FUNC_TO_INPUT_TYPES.put(functionName, typeSet);
        FUNC_REPLACEMENT_NEEDED.add(functionName);
        FUNC_REPLACEMENT_FROM_NON_NULLABLE_VARCHAR.put(functionName, "convertVarChar" + toSuffix);
        FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.put(functionName, "convertNullableVarChar" + toSuffix);
    }

    public static String getCastFunc(TypeProtos.MinorType targetMinorType) {
        String func = TYPE_TO_CAST_FUNC.get(targetMinorType);
        if (func != null) {
            return func;
        }
        throw new IllegalArgumentException(String.format("cast function for type %s is not defined", targetMinorType.name()));
    }

    public static String getReplacingFunction(String functionName, TypeProtos.DataMode dataMode, TypeProtos.MinorType inputType) {
        if (dataMode == TypeProtos.DataMode.OPTIONAL) {
            return FunctionReplacementUtils.getReplacingFunctionFromNullable(functionName, inputType);
        }
        if (dataMode == TypeProtos.DataMode.REQUIRED) {
            return FunctionReplacementUtils.getReplacingFunctionFromNonNullable(functionName, inputType);
        }
        throw new DrillRuntimeException(String.format("replacing function '%s' for datatype %s is not defined", functionName, dataMode));
    }

    public static boolean isReplacementNeeded(String functionName, TypeProtos.MinorType inputType) {
        return FUNC_REPLACEMENT_NEEDED.contains(functionName) && FUNC_TO_INPUT_TYPES.get(functionName).contains(inputType);
    }

    public static boolean isCastFunction(String functionName) {
        return TYPE_TO_CAST_FUNC.values().contains(functionName);
    }

    private static String getReplacingFunctionFromNonNullable(String functionName, TypeProtos.MinorType inputType) {
        if (inputType == TypeProtos.MinorType.VARCHAR && FUNC_REPLACEMENT_FROM_NON_NULLABLE_VARCHAR.containsKey(functionName)) {
            return FUNC_REPLACEMENT_FROM_NON_NULLABLE_VARCHAR.get(functionName);
        }
        if (inputType == TypeProtos.MinorType.VAR16CHAR && FUNC_REPLACEMENT_FROM_NON_NULLABLE_VAR16CHAR.containsKey(functionName)) {
            return FUNC_REPLACEMENT_FROM_NON_NULLABLE_VAR16CHAR.get(functionName);
        }
        if (inputType == TypeProtos.MinorType.VARBINARY && FUNC_REPLACEMENT_FROM_NON_NULLABLE_VARBINARY.containsKey(functionName)) {
            return FUNC_REPLACEMENT_FROM_NON_NULLABLE_VARBINARY.get(functionName);
        }
        throw new DrillRuntimeException(String.format("replacing function for %s is not defined", functionName));
    }

    private static String getReplacingFunctionFromNullable(String functionName, TypeProtos.MinorType inputType) {
        if (inputType == TypeProtos.MinorType.VARCHAR && FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.containsKey(functionName)) {
            return FUNC_REPLACEMENT_FROM_NULLABLE_VARCHAR.get(functionName);
        }
        if (inputType == TypeProtos.MinorType.VAR16CHAR && FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.containsKey(functionName)) {
            return FUNC_REPLACEMENT_FROM_NULLABLE_VAR16CHAR.get(functionName);
        }
        if (inputType == TypeProtos.MinorType.VARBINARY && FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.containsKey(functionName)) {
            return FUNC_REPLACEMENT_FROM_NULLABLE_VARBINARY.get(functionName);
        }
        throw new DrillRuntimeException(String.format("replacing function for %s is not defined", functionName));
    }

    static {
        FunctionReplacementUtils.initCastFunctionSubstitutions();
        FunctionReplacementUtils.initToFunctionSubstitutions();
    }
}

