/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import oadd.org.apache.commons.net.ftp.FTPClientConfig;
import oadd.org.apache.commons.net.ftp.FTPFile;
import oadd.org.apache.commons.net.ftp.FTPFileEntryParser;
import oadd.org.apache.commons.net.ftp.FTPFileFilter;
import oadd.org.apache.commons.net.ftp.FTPFileFilters;
import oadd.org.apache.commons.net.util.Charsets;

public class FTPListParseEngine {
    private static final FTPFile[] EMPTY_FTP_FILE_ARRAY = new FTPFile[0];
    private List<String> entries = new LinkedList<String>();
    private ListIterator<String> internalIterator = this.entries.listIterator();
    private final FTPFileEntryParser parser;
    private final boolean saveUnparseableEntries;

    public FTPListParseEngine(FTPFileEntryParser parser) {
        this(parser, null);
    }

    FTPListParseEngine(FTPFileEntryParser parser, FTPClientConfig configuration) {
        this.parser = parser;
        this.saveUnparseableEntries = configuration != null ? configuration.getUnparseableEntries() : false;
    }

    public List<FTPFile> getFileList(FTPFileFilter filter) {
        return this.entries.stream().map(e -> {
            FTPFile file = this.parser.parseFTPEntry((String)e);
            return file == null && this.saveUnparseableEntries ? new FTPFile((String)e) : file;
        }).filter(file -> filter.accept((FTPFile)file)).collect(Collectors.toList());
    }

    public FTPFile[] getFiles() throws IOException {
        return this.getFiles(FTPFileFilters.NON_NULL);
    }

    public FTPFile[] getFiles(FTPFileFilter filter) throws IOException {
        return this.getFileList(filter).toArray(EMPTY_FTP_FILE_ARRAY);
    }

    public FTPFile[] getNext(int quantityRequested) {
        LinkedList<FTPFile> tmpResults = new LinkedList<FTPFile>();
        for (int count = quantityRequested; count > 0 && this.internalIterator.hasNext(); --count) {
            String entry = this.internalIterator.next();
            FTPFile temp = this.parser.parseFTPEntry(entry);
            if (temp == null && this.saveUnparseableEntries) {
                temp = new FTPFile(entry);
            }
            tmpResults.add(temp);
        }
        return tmpResults.toArray(EMPTY_FTP_FILE_ARRAY);
    }

    public FTPFile[] getPrevious(int quantityRequested) {
        LinkedList<FTPFile> tmpResults = new LinkedList<FTPFile>();
        for (int count = quantityRequested; count > 0 && this.internalIterator.hasPrevious(); --count) {
            String entry = this.internalIterator.previous();
            FTPFile temp = this.parser.parseFTPEntry(entry);
            if (temp == null && this.saveUnparseableEntries) {
                temp = new FTPFile(entry);
            }
            tmpResults.add(0, temp);
        }
        return tmpResults.toArray(EMPTY_FTP_FILE_ARRAY);
    }

    public boolean hasNext() {
        return this.internalIterator.hasNext();
    }

    public boolean hasPrevious() {
        return this.internalIterator.hasPrevious();
    }

    private void read(InputStream inputStream, String charsetName) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charsets.toCharset(charsetName)));){
            String line = this.parser.readNextEntry(reader);
            while (line != null) {
                this.entries.add(line);
                line = this.parser.readNextEntry(reader);
            }
        }
    }

    @Deprecated
    public void readServerList(InputStream inputStream) throws IOException {
        this.readServerList(inputStream, null);
    }

    public void readServerList(InputStream inputStream, String charsetName) throws IOException {
        this.entries = new LinkedList<String>();
        this.read(inputStream, charsetName);
        this.parser.preParse(this.entries);
        this.resetIterator();
    }

    public void resetIterator() {
        this.internalIterator = this.entries.listIterator();
    }
}

