/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.lang3;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import oadd.org.apache.commons.lang3.Streams;

public class Functions {
    public static Runnable asRunnable(FailableRunnable<?> runnable) {
        return () -> Functions.run(runnable);
    }

    public static <I> Consumer<I> asConsumer(FailableConsumer<I, ?> consumer) {
        return input -> Functions.accept(consumer, input);
    }

    public static <O> Callable<O> asCallable(FailableCallable<O, ?> callable) {
        return () -> Functions.call(callable);
    }

    public static <I1, I2> BiConsumer<I1, I2> asBiConsumer(FailableBiConsumer<I1, I2, ?> consumer) {
        return (input1, input2) -> Functions.accept(consumer, input1, input2);
    }

    public static <I, O> Function<I, O> asFunction(FailableFunction<I, O, ?> function) {
        return input -> Functions.apply(function, input);
    }

    public static <I1, I2, O> BiFunction<I1, I2, O> asBiFunction(FailableBiFunction<I1, I2, O, ?> function) {
        return (input1, input2) -> Functions.apply(function, input1, input2);
    }

    public static <I> Predicate<I> asPredicate(FailablePredicate<I, ?> predicate) {
        return input -> Functions.test(predicate, input);
    }

    public static <I1, I2> BiPredicate<I1, I2> asBiPredicate(FailableBiPredicate<I1, I2, ?> predicate) {
        return (input1, input2) -> Functions.test(predicate, input1, input2);
    }

    public static <O> Supplier<O> asSupplier(FailableSupplier<O, ?> supplier) {
        return () -> Functions.get(supplier);
    }

    public static <T extends Throwable> void run(FailableRunnable<T> runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t2) {
            throw Functions.rethrow(t2);
        }
    }

    public static <O, T extends Throwable> O call(FailableCallable<O, T> callable) {
        return (O)Functions.get(callable::call);
    }

    public static <O, T extends Throwable> void accept(FailableConsumer<O, T> consumer, O object) {
        Functions.run(() -> consumer.accept(object));
    }

    public static <O1, O2, T extends Throwable> void accept(FailableBiConsumer<O1, O2, T> consumer, O1 object1, O2 object2) {
        Functions.run(() -> consumer.accept(object1, object2));
    }

    public static <I, O, T extends Throwable> O apply(FailableFunction<I, O, T> function, I input) {
        return (O)Functions.get(() -> function.apply(input));
    }

    public static <I1, I2, O, T extends Throwable> O apply(FailableBiFunction<I1, I2, O, T> function, I1 input1, I2 input2) {
        return (O)Functions.get(() -> function.apply(input1, input2));
    }

    public static <O, T extends Throwable> boolean test(FailablePredicate<O, T> predicate, O object) {
        return Functions.get(() -> predicate.test(object));
    }

    public static <O1, O2, T extends Throwable> boolean test(FailableBiPredicate<O1, O2, T> predicate, O1 object1, O2 object2) {
        return Functions.get(() -> predicate.test(object1, object2));
    }

    public static <O, T extends Throwable> O get(FailableSupplier<O, T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t2) {
            throw Functions.rethrow(t2);
        }
    }

    public static <O> Streams.FailableStream<O> stream(Stream<O> stream) {
        return new Streams.FailableStream<O>(stream);
    }

    public static <O> Streams.FailableStream<O> stream(Collection<O> collection) {
        return new Streams.FailableStream<O>(collection.stream());
    }

    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> action, FailableConsumer<Throwable, ? extends Throwable> errorHandler, FailableRunnable<? extends Throwable> ... resources) {
        FailableConsumer<Throwable, Object> actualErrorHandler = errorHandler == null ? Functions::rethrow : errorHandler;
        if (resources != null) {
            for (FailableRunnable<? extends Throwable> failableRunnable : resources) {
                Objects.requireNonNull(failableRunnable, "runnable");
            }
        }
        Throwable th = null;
        try {
            action.run();
        }
        catch (Throwable t2) {
            th = t2;
        }
        if (resources != null) {
            for (FailableRunnable<? extends Throwable> runnable : resources) {
                try {
                    runnable.run();
                }
                catch (Throwable t3) {
                    if (th != null) continue;
                    th = t3;
                }
            }
        }
        if (th != null) {
            try {
                actualErrorHandler.accept(th);
            }
            catch (Throwable t4) {
                throw Functions.rethrow(t4);
            }
        }
    }

    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> action, FailableRunnable<? extends Throwable> ... resources) {
        Functions.tryWithResources(action, null, resources);
    }

    public static RuntimeException rethrow(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable");
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof IOException) {
            throw new UncheckedIOException((IOException)throwable);
        }
        throw new UndeclaredThrowableException(throwable);
    }

    @FunctionalInterface
    public static interface FailableSupplier<O, T extends Throwable> {
        public O get() throws T;
    }

    @FunctionalInterface
    public static interface FailableBiPredicate<O1, O2, T extends Throwable> {
        public boolean test(O1 var1, O2 var2) throws T;
    }

    @FunctionalInterface
    public static interface FailablePredicate<O, T extends Throwable> {
        public boolean test(O var1) throws T;
    }

    @FunctionalInterface
    public static interface FailableBiFunction<I1, I2, O, T extends Throwable> {
        public O apply(I1 var1, I2 var2) throws T;
    }

    @FunctionalInterface
    public static interface FailableFunction<I, O, T extends Throwable> {
        public O apply(I var1) throws T;
    }

    @FunctionalInterface
    public static interface FailableBiConsumer<O1, O2, T extends Throwable> {
        public void accept(O1 var1, O2 var2) throws T;
    }

    @FunctionalInterface
    public static interface FailableConsumer<O, T extends Throwable> {
        public void accept(O var1) throws T;
    }

    @FunctionalInterface
    public static interface FailableCallable<O, T extends Throwable> {
        public O call() throws T;
    }

    @FunctionalInterface
    public static interface FailableRunnable<T extends Throwable> {
        public void run() throws T;
    }
}

