/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.io;

import oadd.io.jsonwebtoken.io.Encoder;
import oadd.io.jsonwebtoken.io.EncodingException;
import oadd.io.jsonwebtoken.lang.Assert;

class ExceptionPropagatingEncoder<T, R>
implements Encoder<T, R> {
    private final Encoder<T, R> encoder;

    ExceptionPropagatingEncoder(Encoder<T, R> encoder) {
        Assert.notNull(encoder, "Encoder cannot be null.");
        this.encoder = encoder;
    }

    @Override
    public R encode(T t2) throws EncodingException {
        Assert.notNull(t2, "Encode argument cannot be null.");
        try {
            return this.encoder.encode(t2);
        }
        catch (EncodingException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unable to encode input: " + e.getMessage();
            throw new EncodingException(msg, e);
        }
    }
}

