/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.impl.compression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oadd.io.jsonwebtoken.CompressionCodec;
import oadd.io.jsonwebtoken.CompressionException;
import oadd.io.jsonwebtoken.lang.Assert;
import oadd.io.jsonwebtoken.lang.Objects;

public abstract class AbstractCompressionCodec
implements CompressionCodec {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readAndClose(InputStream input) throws IOException {
        byte[] buffer = new byte[512];
        ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.length);
        try {
            int read = input.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = input.read(buffer);
            }
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(input);
            throw throwable;
        }
        Objects.nullSafeClose(input);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] writeAndClose(byte[] payload, StreamWrapper wrapper) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(512);
        OutputStream compressionStream = wrapper.wrap(outputStream);
        try {
            compressionStream.write(payload);
            compressionStream.flush();
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(compressionStream);
            throw throwable;
        }
        Objects.nullSafeClose(compressionStream);
        return outputStream.toByteArray();
    }

    protected abstract byte[] doCompress(byte[] var1) throws IOException;

    @Override
    public final byte[] compress(byte[] payload) {
        Assert.notNull(payload, "payload cannot be null.");
        try {
            return this.doCompress(payload);
        }
        catch (IOException e) {
            throw new CompressionException("Unable to compress payload.", e);
        }
    }

    @Override
    public final byte[] decompress(byte[] compressed) {
        Assert.notNull(compressed, "compressed bytes cannot be null.");
        try {
            return this.doDecompress(compressed);
        }
        catch (IOException e) {
            throw new CompressionException("Unable to decompress bytes.", e);
        }
    }

    protected abstract byte[] doDecompress(byte[] var1) throws IOException;

    static interface StreamWrapper {
        public OutputStream wrap(OutputStream var1) throws IOException;
    }
}

