/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import oadd.com.carrotsearch.hppc.BitMixer;
import oadd.com.carrotsearch.hppc.HashOrderMixing;
import oadd.com.carrotsearch.hppc.HashOrderMixingStrategy;
import oadd.com.carrotsearch.hppc.ObjectContainer;
import oadd.com.carrotsearch.hppc.ObjectHashSet;

public class ObjectIdentityHashSet<KType>
extends ObjectHashSet<KType> {
    public ObjectIdentityHashSet() {
        this(4, 0.75);
    }

    public ObjectIdentityHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectIdentityHashSet(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.randomized());
    }

    public ObjectIdentityHashSet(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ObjectIdentityHashSet(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    protected int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mix(key, this.keyMixer);
    }

    @Override
    protected boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    @SafeVarargs
    public static <KType> ObjectIdentityHashSet<KType> from(KType ... elements) {
        ObjectIdentityHashSet<KType> set = new ObjectIdentityHashSet<KType>(elements.length);
        set.addAll(elements);
        return set;
    }
}

