/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import java.io.IOException;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketExtensionFactory
extends ExtensionFactory
implements LifeCycle,
Dumpable {
    private final ContainerLifeCycle containerLifeCycle;
    private final WebSocketContainerScope container;
    private final InflaterPool inflaterPool;
    private final DeflaterPool deflaterPool;

    public WebSocketExtensionFactory(WebSocketContainerScope container) {
        this(container, null, null);
    }

    public WebSocketExtensionFactory(WebSocketContainerScope container, InflaterPool inflaterPool, DeflaterPool deflaterPool) {
        this.container = container;
        this.containerLifeCycle = new ContainerLifeCycle(){

            public String toString() {
                return String.format("%s@%x{%s}", WebSocketExtensionFactory.class.getSimpleName(), ((Object)((Object)this)).hashCode(), WebSocketExtensionFactory.this.containerLifeCycle.getState());
            }
        };
        this.inflaterPool = inflaterPool != null ? inflaterPool : new InflaterPool(-1, true);
        this.containerLifeCycle.addBean((Object)this.inflaterPool);
        this.deflaterPool = deflaterPool != null ? deflaterPool : new DeflaterPool(-1, -1, true);
        this.containerLifeCycle.addBean((Object)this.deflaterPool);
    }

    public void unmanage(Object object) {
        this.containerLifeCycle.unmanage(object);
    }

    public InflaterPool getInflaterPool() {
        return this.inflaterPool;
    }

    public DeflaterPool getDeflaterPool() {
        return this.deflaterPool;
    }

    @Override
    public Extension newInstance(ExtensionConfig config) {
        if (config == null) {
            return null;
        }
        String name = config.getName();
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        Class<? extends Extension> extClass = this.getExtension(name);
        if (extClass == null) {
            return null;
        }
        try {
            Extension ext = (Extension)this.container.getObjectFactory().createInstance(extClass);
            if (ext instanceof AbstractExtension) {
                AbstractExtension aext = (AbstractExtension)ext;
                aext.init(this.container);
                aext.setConfig(config);
            }
            if (ext instanceof CompressExtension) {
                CompressExtension cext = (CompressExtension)ext;
                cext.setInflaterPool(this.inflaterPool);
                cext.setDeflaterPool(this.deflaterPool);
            }
            return ext;
        }
        catch (Exception e) {
            throw new WebSocketException("Cannot instantiate extension: " + extClass, e);
        }
    }

    public void start() throws Exception {
        this.containerLifeCycle.start();
    }

    public void stop() throws Exception {
        this.containerLifeCycle.stop();
    }

    public boolean isRunning() {
        return this.containerLifeCycle.isRunning();
    }

    public boolean isStarted() {
        return this.containerLifeCycle.isStarted();
    }

    public boolean isStarting() {
        return this.containerLifeCycle.isStarting();
    }

    public boolean isStopping() {
        return this.containerLifeCycle.isStopping();
    }

    public boolean isStopped() {
        return this.containerLifeCycle.isStopped();
    }

    public boolean isFailed() {
        return this.containerLifeCycle.isFailed();
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this.containerLifeCycle.addLifeCycleListener(listener);
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this.containerLifeCycle.removeLifeCycleListener(listener);
    }

    public String dump() {
        return this.containerLifeCycle.dump();
    }

    public String dumpSelf() {
        return this.containerLifeCycle.dumpSelf();
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.containerLifeCycle.dump(out, indent);
    }

    public String toString() {
        return this.containerLifeCycle.toString();
    }
}

