/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmChecker;
import org.bouncycastle.jsse.provider.ProvX509Key;
import org.bouncycastle.jsse.provider.ProvX509KeyManager;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;
import org.bouncycastle.jsse.provider.TransportData;
import org.bouncycastle.tls.TlsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvX509KeyManagerSimple
extends BCX509ExtendedKeyManager {
    private static final Logger LOG = Logger.getLogger(ProvX509KeyManagerSimple.class.getName());
    private final boolean isInFipsMode;
    private final JcaJceHelper helper;
    private final Map<String, Credential> credentials;
    private static final Map<String, PublicKeyFilter> FILTERS_CLIENT = ProvX509KeyManagerSimple.createFiltersClient();
    private static final Map<String, PublicKeyFilter> FILTERS_SERVER = ProvX509KeyManagerSimple.createFiltersServer();

    private static void addFilter(Map<String, PublicKeyFilter> filters, String keyType) {
        String algorithm = keyType;
        ProvX509KeyManagerSimple.addFilter(filters, 0, algorithm, null, keyType);
    }

    private static void addFilter(Map<String, PublicKeyFilter> filters, Class<? extends PublicKey> clazz, String ... keyTypes) {
        ProvX509KeyManagerSimple.addFilter(filters, 0, null, clazz, keyTypes);
    }

    private static void addFilter(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, Class<? extends PublicKey> clazz, String ... keyTypes) {
        PublicKeyFilter filter = new PublicKeyFilter(algorithm, clazz, keyUsageBit);
        for (String keyType : keyTypes) {
            if (null == filters.put(keyType.toUpperCase(Locale.ENGLISH), filter)) continue;
            throw new IllegalStateException("Duplicate keys in filters");
        }
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, String algorithm, int ... keyExchangeAlgorithms) {
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, 0, algorithm, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, int ... keyExchangeAlgorithms) {
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, keyUsageBit, algorithm, null, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, Class<? extends PublicKey> clazz, int ... keyExchangeAlgorithms) {
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, 0, null, clazz, keyExchangeAlgorithms);
    }

    private static void addFilterLegacyServer(Map<String, PublicKeyFilter> filters, int keyUsageBit, String algorithm, Class<? extends PublicKey> clazz, int ... keyExchangeAlgorithms) {
        ProvX509KeyManagerSimple.addFilter(filters, keyUsageBit, algorithm, clazz, ProvX509KeyManagerSimple.getKeyTypesLegacyServer(keyExchangeAlgorithms));
    }

    private static Map<String, PublicKeyFilter> createFiltersClient() {
        HashMap<String, PublicKeyFilter> filters = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManagerSimple.addFilter(filters, "Ed25519");
        ProvX509KeyManagerSimple.addFilter(filters, "Ed448");
        ProvX509KeyManagerSimple.addFilter(filters, "RSA");
        ProvX509KeyManagerSimple.addFilter(filters, "RSASSA-PSS");
        ProvX509KeyManagerSimple.addFilter(filters, DSAPublicKey.class, "DSA");
        ProvX509KeyManagerSimple.addFilter(filters, ECPublicKey.class, "EC");
        return Collections.unmodifiableMap(filters);
    }

    private static Map<String, PublicKeyFilter> createFiltersServer() {
        HashMap<String, PublicKeyFilter> filters = new HashMap<String, PublicKeyFilter>();
        ProvX509KeyManagerSimple.addFilter(filters, "Ed25519");
        ProvX509KeyManagerSimple.addFilter(filters, "Ed448");
        ProvX509KeyManagerSimple.addFilter(filters, "RSA");
        ProvX509KeyManagerSimple.addFilter(filters, "RSASSA-PSS");
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, DSAPublicKey.class, 3, 22);
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, ECPublicKey.class, 17);
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, "RSA", 5, 19, 23);
        ProvX509KeyManagerSimple.addFilterLegacyServer(filters, 2, "RSA", 1);
        return Collections.unmodifiableMap(filters);
    }

    private static String[] getKeyTypesLegacyServer(int ... keyExchangeAlgorithms) {
        int count = keyExchangeAlgorithms.length;
        String[] keyTypes = new String[count];
        for (int i = 0; i < count; ++i) {
            keyTypes[i] = JsseUtils.getKeyTypeLegacyServer(keyExchangeAlgorithms[i]);
        }
        return keyTypes;
    }

    private static Map<String, Credential> loadCredentials(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        HashMap<String, Credential> credentials = new HashMap<String, Credential>(4);
        if (null != ks) {
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                Object[] certificateChain;
                PrivateKey privateKey;
                String alias = aliases.nextElement();
                if (!ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) || null == (privateKey = (PrivateKey)ks.getKey(alias, password)) || TlsUtils.isNullOrEmpty(certificateChain = JsseUtils.getX509CertificateChain(ks.getCertificateChain(alias)))) continue;
                credentials.put(alias, new Credential(alias, privateKey, (X509Certificate[])certificateChain));
            }
        }
        return Collections.unmodifiableMap(credentials);
    }

    ProvX509KeyManagerSimple(boolean isInFipsMode, JcaJceHelper helper, KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.isInFipsMode = isInFipsMode;
        this.helper = helper;
        this.credentials = ProvX509KeyManagerSimple.loadCredentials(ks, password);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(keyTypes), issuers, TransportData.from(socket), false);
    }

    @Override
    public BCX509Key chooseClientKeyBC(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(keyTypes), issuers, TransportData.from(socket), false);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(keyTypes), issuers, TransportData.from(engine), false);
    }

    @Override
    public BCX509Key chooseEngineClientKeyBC(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(keyTypes), issuers, TransportData.from(engine), false);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(keyType), issuers, TransportData.from(engine), true);
    }

    @Override
    public BCX509Key chooseEngineServerKeyBC(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(keyType), issuers, TransportData.from(engine), true);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(ProvX509KeyManagerSimple.getKeyTypes(keyType), issuers, TransportData.from(socket), true);
    }

    @Override
    public BCX509Key chooseServerKeyBC(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseKeyBC(ProvX509KeyManagerSimple.getKeyTypes(keyType), issuers, TransportData.from(socket), true);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        Credential credential = this.getCredential(alias);
        return null == credential ? null : (X509Certificate[])credential.certificateChain.clone();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(ProvX509KeyManagerSimple.getKeyTypes(keyType), issuers, null, false);
    }

    @Override
    public BCX509Key getKeyBC(String alias) {
        Credential credential = this.getCredential(alias);
        return this.createKeyBC(credential);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        Credential credential = this.getCredential(alias);
        return null == credential ? null : credential.privateKey;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(ProvX509KeyManagerSimple.getKeyTypes(keyType), issuers, null, true);
    }

    private String chooseAlias(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        Match bestMatch = this.getBestMatch(keyTypes, issuers, transportData, forServer);
        if (Match.NOTHING != bestMatch) {
            String alias = ProvX509KeyManagerSimple.getAlias(bestMatch);
            LOG.fine("Found matching key, returning alias: " + alias);
            return alias;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key chooseKeyBC(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        BCX509Key keyBC;
        Match bestMatch = this.getBestMatch(keyTypes, issuers, transportData, forServer);
        if (Match.NOTHING != bestMatch && null != (keyBC = this.createKeyBC(bestMatch.credential))) {
            LOG.fine("Found matching key, from alias: " + ProvX509KeyManagerSimple.getAlias(bestMatch));
            return keyBC;
        }
        LOG.fine("No matching key found");
        return null;
    }

    private BCX509Key createKeyBC(Credential credential) {
        return null == credential ? null : new ProvX509Key(credential.privateKey, credential.certificateChain);
    }

    private String[] getAliases(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        if (!this.credentials.isEmpty() && !keyTypes.isEmpty()) {
            Set<Principal> uniqueIssuers = ProvX509KeyManagerSimple.getUniquePrincipals(issuers);
            BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date atDate = new Date();
            String requestedHostName = ProvX509KeyManagerSimple.getRequestedHostName(transportData, forServer);
            List<Match> allMatches = null;
            try {
                allMatches = this.getAliasesFromCredentials(keyTypes, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != allMatches && !allMatches.isEmpty()) {
                Collections.sort(allMatches);
                return ProvX509KeyManagerSimple.getAliases(allMatches);
            }
        }
        return null;
    }

    private List<Match> getAliasesFromCredentials(List<String> keyTypes, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer, Date atDate, String requestedHostName) throws Exception {
        List<Match> matches = null;
        for (Credential credential : this.credentials.values()) {
            Match match = this.getPotentialMatch(credential, Match.Quality.NONE, keyTypes, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
            if (null == match) continue;
            matches = ProvX509KeyManagerSimple.addToMatches(matches, match);
        }
        return matches;
    }

    private Match getBestMatch(List<String> keyTypes, Principal[] issuers, TransportData transportData, boolean forServer) {
        if (!this.credentials.isEmpty() && !keyTypes.isEmpty()) {
            Set<Principal> uniqueIssuers = ProvX509KeyManagerSimple.getUniquePrincipals(issuers);
            BCAlgorithmConstraints algorithmConstraints = TransportData.getAlgorithmConstraints(transportData, true);
            Date atDate = new Date();
            String requestedHostName = ProvX509KeyManagerSimple.getRequestedHostName(transportData, forServer);
            try {
                return this.getBestMatchFromCredentials(keyTypes, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Match.NOTHING;
    }

    private Match getBestMatchFromCredentials(List<String> keyTypes, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer, Date atDate, String requestedHostName) throws Exception {
        Match bestMatch = Match.NOTHING;
        for (Credential credential : this.credentials.values()) {
            Match match = this.getPotentialMatch(credential, bestMatch.quality, keyTypes, uniqueIssuers, algorithmConstraints, forServer, atDate, requestedHostName);
            if (null == match) continue;
            bestMatch = match;
            if (Match.Quality.OK != bestMatch.quality) continue;
            break;
        }
        return bestMatch;
    }

    private Match getPotentialMatch(Credential credential, Match.Quality qualityLimit, List<String> keyTypes, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer, Date atDate, String requestedHostName) throws Exception {
        Match.Quality quality;
        X509Certificate[] chain = credential.certificateChain;
        if (this.isSuitableChain(chain, keyTypes, uniqueIssuers, algorithmConstraints, forServer) && (quality = ProvX509KeyManagerSimple.getCertificateQuality(chain[0], atDate, requestedHostName)).compareTo(qualityLimit) < 0) {
            return new Match(quality, credential);
        }
        return null;
    }

    private Credential getCredential(String alias) {
        return null == alias ? null : this.credentials.get(alias);
    }

    private boolean isSuitableChain(X509Certificate[] chain, List<String> keyTypes, Set<Principal> uniqueIssuers, BCAlgorithmConstraints algorithmConstraints, boolean forServer) {
        if (TlsUtils.isNullOrEmpty(chain) || !ProvX509KeyManagerSimple.isSuitableChainForIssuers(chain, uniqueIssuers) || !ProvX509KeyManagerSimple.isSuitableEECert(chain[0], keyTypes, algorithmConstraints, forServer)) {
            return false;
        }
        try {
            Set<X509Certificate> trustedCerts = Collections.emptySet();
            KeyPurposeId ekuOID = ProvX509KeyManager.getRequiredExtendedKeyUsage(forServer);
            int kuBit = -1;
            ProvAlgorithmChecker.checkChain(this.isInFipsMode, this.helper, algorithmConstraints, trustedCerts, chain, ekuOID, kuBit);
        }
        catch (CertPathValidatorException e) {
            return false;
        }
        return true;
    }

    private static List<Match> addToMatches(List<Match> matches, Match match) {
        if (null == matches) {
            matches = new ArrayList<Match>();
        }
        matches.add(match);
        return matches;
    }

    private static String getAlias(Match match) {
        return match.credential.alias;
    }

    private static String[] getAliases(List<Match> matches) {
        int count = matches.size();
        int pos = 0;
        String[] result = new String[count];
        for (Match match : matches) {
            result[pos++] = ProvX509KeyManagerSimple.getAlias(match);
        }
        return result;
    }

    private static Match.Quality getCertificateQuality(X509Certificate certificate, Date atDate, String requestedHostName) {
        boolean[] keyUsage;
        try {
            certificate.checkValidity(atDate);
        }
        catch (CertificateException e) {
            return Match.Quality.EXPIRED;
        }
        if (null != requestedHostName) {
            try {
                ProvX509TrustManager.checkEndpointID(requestedHostName, certificate, "HTTPS");
            }
            catch (CertificateException e) {
                return Match.Quality.MISMATCH_SNI;
            }
        }
        if ("RSA".equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(certificate.getPublicKey())) && ProvAlgorithmChecker.supportsKeyUsage(keyUsage = certificate.getKeyUsage(), 0) && ProvAlgorithmChecker.supportsKeyUsage(keyUsage, 2)) {
            return Match.Quality.RSA_MULTI_USE;
        }
        return Match.Quality.OK;
    }

    private static List<String> getKeyTypes(String ... keyTypes) {
        if (null != keyTypes && keyTypes.length > 0) {
            ArrayList<String> result = new ArrayList<String>(keyTypes.length);
            for (String keyType : keyTypes) {
                if (null == keyType) continue;
                result.add(keyType.toUpperCase(Locale.ENGLISH));
            }
            if (!result.isEmpty()) {
                return Collections.unmodifiableList(result);
            }
        }
        return Collections.emptyList();
    }

    private static String getRequestedHostName(TransportData transportData, boolean forServer) {
        BCSNIHostName sniHostName;
        BCExtendedSSLSession sslSession;
        if (null != transportData && forServer && null != (sslSession = transportData.getHandshakeSession()) && null != (sniHostName = JsseUtils.getSNIHostName(sslSession.getRequestedServerNames()))) {
            return sniHostName.getAsciiName();
        }
        return null;
    }

    private static Set<Principal> getUniquePrincipals(Principal[] principals) {
        if (null == principals) {
            return null;
        }
        if (principals.length > 0) {
            HashSet<Principal> result = new HashSet<Principal>();
            for (int i = 0; i < principals.length; ++i) {
                Principal principal = principals[i];
                if (null == principal) continue;
                result.add(principal);
            }
            if (!result.isEmpty()) {
                return Collections.unmodifiableSet(result);
            }
        }
        return Collections.emptySet();
    }

    private static boolean isSuitableChainForIssuers(X509Certificate[] chain, Set<Principal> uniqueIssuers) {
        if (null == uniqueIssuers || uniqueIssuers.isEmpty()) {
            return true;
        }
        int pos = chain.length;
        while (--pos >= 0) {
            if (!uniqueIssuers.contains(chain[pos].getIssuerX500Principal())) continue;
            return true;
        }
        X509Certificate eeCert = chain[0];
        return eeCert.getBasicConstraints() >= 0 && uniqueIssuers.contains(eeCert.getSubjectX500Principal());
    }

    private static boolean isSuitableEECert(X509Certificate eeCert, List<String> keyTypes, BCAlgorithmConstraints algorithmConstraints, boolean forServer) {
        Map<String, PublicKeyFilter> filters = forServer ? FILTERS_SERVER : FILTERS_CLIENT;
        PublicKey publicKey = eeCert.getPublicKey();
        boolean[] keyUsage = eeCert.getKeyUsage();
        for (String keyType : keyTypes) {
            PublicKeyFilter filter = filters.get(keyType);
            if (null == filter || !filter.accepts(publicKey, keyUsage, algorithmConstraints)) continue;
            return true;
        }
        return false;
    }

    private static class Credential {
        private final String alias;
        private final PrivateKey privateKey;
        private final X509Certificate[] certificateChain;

        Credential(String alias, PrivateKey privateKey, X509Certificate[] certificateChain) {
            this.alias = alias;
            this.privateKey = privateKey;
            this.certificateChain = certificateChain;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Match
    implements Comparable<Match> {
        static final Match NOTHING = new Match(Quality.NONE, null);
        final Quality quality;
        final Credential credential;

        Match(Quality quality, Credential credential) {
            this.quality = quality;
            this.credential = credential;
        }

        @Override
        public int compareTo(Match other) {
            return this.quality.compareTo(other.quality);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Quality {
            OK,
            RSA_MULTI_USE,
            MISMATCH_SNI,
            EXPIRED,
            NONE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PublicKeyFilter {
        final String algorithm;
        final Class<? extends PublicKey> clazz;
        final int keyUsageBit;

        PublicKeyFilter(String algorithm, Class<? extends PublicKey> clazz, int keyUsageBit) {
            this.algorithm = algorithm;
            this.clazz = clazz;
            this.keyUsageBit = keyUsageBit;
        }

        boolean accepts(PublicKey publicKey, boolean[] keyUsage, BCAlgorithmConstraints algorithmConstraints) {
            return this.appliesTo(publicKey) && ProvAlgorithmChecker.permitsKeyUsage(publicKey, keyUsage, this.keyUsageBit, algorithmConstraints);
        }

        private boolean appliesTo(PublicKey publicKey) {
            return null != this.algorithm && this.algorithm.equalsIgnoreCase(JsseUtils.getPublicKeyAlgorithm(publicKey)) || null != this.clazz && this.clazz.isInstance(publicKey);
        }
    }
}

