/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.fn;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.databind.JsonNode;
import oadd.com.google.common.base.Charsets;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.physical.base.GroupScan;
import oadd.org.apache.drill.exec.store.easy.json.reader.BaseJsonReader;
import oadd.org.apache.drill.exec.vector.complex.fn.DrillBufInputStream;
import oadd.org.apache.drill.exec.vector.complex.fn.FieldSelection;
import oadd.org.apache.drill.exec.vector.complex.fn.JsonReaderUtils;
import oadd.org.apache.drill.exec.vector.complex.fn.SeekableBAIS;
import oadd.org.apache.drill.exec.vector.complex.fn.VectorOutput;
import oadd.org.apache.drill.exec.vector.complex.fn.WorkingBuffer;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReader
extends BaseJsonReader {
    private static final Logger logger = LoggerFactory.getLogger(JsonReader.class);
    public static final int MAX_RECORD_SIZE = 131072;
    private final WorkingBuffer workingBuffer;
    private final List<SchemaPath> columns;
    private final boolean allTextMode;
    private final VectorOutput.MapVectorOutput mapOutput;
    private final VectorOutput.ListVectorOutput listOutput;
    private final boolean extended = true;
    private final boolean readNumbersAsDouble;
    private final List<BaseWriter.ListWriter> emptyArrayWriters = Lists.newArrayList();
    private final FieldSelection selection;

    public JsonReader(Builder builder) {
        super(builder.managedBuf, builder.enableNanInf, builder.enableEscapeAnyChar, builder.skipOuterList);
        this.selection = FieldSelection.getFieldSelection(builder.columns);
        this.workingBuffer = builder.workingBuffer;
        this.allTextMode = builder.allTextMode;
        this.columns = builder.columns;
        this.mapOutput = builder.mapOutput;
        this.listOutput = builder.listOutput;
        this.currentFieldName = "<none>";
        this.readNumbersAsDouble = builder.readNumbersAsDouble;
    }

    public void ensureAtLeastOneField(BaseWriter.ComplexWriter writer) {
        JsonReaderUtils.ensureAtLeastOneField(writer, this.columns, this.allTextMode, this.emptyArrayWriters);
    }

    public void setSource(int start, int end, DrillBuf buf) throws IOException {
        this.setSource(DrillBufInputStream.getStream(start, end, buf));
    }

    public void setSource(InputStream is) throws IOException {
        super.setSource(is);
        this.mapOutput.setParser(this.parser);
        this.listOutput.setParser(this.parser);
    }

    public void setSource(JsonNode node) {
        super.setSource(node);
        this.mapOutput.setParser(this.parser);
        this.listOutput.setParser(this.parser);
    }

    public void setSource(String data) throws IOException {
        this.setSource(data.getBytes(Charsets.UTF_8));
    }

    public void setSource(byte[] bytes) throws IOException {
        this.setSource(new SeekableBAIS(bytes));
    }

    protected void writeDocument(BaseWriter.ComplexWriter writer, JsonToken t2) throws IOException {
        switch (t2) {
            case START_OBJECT: {
                this.writeDataSwitch(writer.rootAsMap());
                break;
            }
            case START_ARRAY: {
                this.writeDataSwitch(writer.rootAsList());
                break;
            }
            default: {
                throw this.createDocumentTopLevelException();
            }
        }
    }

    private void writeDataSwitch(BaseWriter.MapWriter w) throws IOException {
        if (this.allTextMode) {
            this.writeDataAllText(w, this.selection, true);
        } else {
            this.writeData(w, this.selection, true);
        }
    }

    private void writeDataSwitch(BaseWriter.ListWriter w) throws IOException {
        if (this.allTextMode) {
            this.writeDataAllText(w);
        } else {
            this.writeData(w);
        }
    }

    private void consumeEntireNextValue() throws IOException {
        switch (this.parser.nextToken()) {
            case START_OBJECT: 
            case START_ARRAY: {
                this.parser.skipChildren();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(BaseWriter.MapWriter map, FieldSelection selection, boolean moveForward) throws IOException {
        block22: {
            map.start();
            try {
                block15: while (true) {
                    String fieldName;
                    JsonToken t2;
                    if (moveForward) {
                        t2 = this.parser.nextToken();
                    } else {
                        t2 = this.parser.getCurrentToken();
                        moveForward = true;
                    }
                    if (t2 == JsonToken.NOT_AVAILABLE || t2 == JsonToken.END_OBJECT) {
                        return;
                    }
                    assert (t2 == JsonToken.FIELD_NAME) : String.format("Expected FIELD_NAME but got %s.", t2.name());
                    this.currentFieldName = fieldName = this.parser.getText();
                    FieldSelection childSelection = selection.getChild(fieldName);
                    if (childSelection.isNeverValid()) {
                        this.consumeEntireNextValue();
                        continue;
                    }
                    switch (this.parser.nextToken()) {
                        case START_ARRAY: {
                            this.writeData(map.list(fieldName));
                            break;
                        }
                        case START_OBJECT: {
                            if (this.writeMapDataIfTyped(map, fieldName)) continue block15;
                            this.writeData(map.map(fieldName), childSelection, false);
                            break;
                        }
                        case END_OBJECT: {
                            break block22;
                        }
                        case VALUE_FALSE: {
                            map.bit(fieldName).writeBit(0);
                            break;
                        }
                        case VALUE_TRUE: {
                            map.bit(fieldName).writeBit(1);
                            break;
                        }
                        case VALUE_NULL: {
                            break;
                        }
                        case VALUE_NUMBER_FLOAT: {
                            map.float8(fieldName).writeFloat8(this.parser.getDoubleValue());
                            break;
                        }
                        case VALUE_NUMBER_INT: {
                            if (this.readNumbersAsDouble) {
                                map.float8(fieldName).writeFloat8(this.parser.getDoubleValue());
                                break;
                            }
                            map.bigInt(fieldName).writeBigInt(this.parser.getLongValue());
                            break;
                        }
                        case VALUE_STRING: {
                            this.handleString(this.parser, map, fieldName);
                            break;
                        }
                        default: {
                            throw this.getExceptionWithContext(UserException.dataReadError(), null).message("Unexpected token %s", new Object[]{this.parser.getCurrentToken()}).build(logger);
                        }
                    }
                }
            }
            finally {
                map.end();
            }
        }
    }

    private void writeDataAllText(BaseWriter.MapWriter map, FieldSelection selection, boolean moveForward) throws IOException {
        map.start();
        block7: while (true) {
            String fieldName;
            JsonToken t2;
            if (moveForward) {
                t2 = this.parser.nextToken();
            } else {
                t2 = this.parser.getCurrentToken();
                moveForward = true;
            }
            if (t2 == JsonToken.NOT_AVAILABLE || t2 == JsonToken.END_OBJECT) {
                return;
            }
            assert (t2 == JsonToken.FIELD_NAME) : String.format("Expected FIELD_NAME but got %s.", t2.name());
            this.currentFieldName = fieldName = this.parser.getText();
            FieldSelection childSelection = selection.getChild(fieldName);
            if (childSelection.isNeverValid()) {
                this.consumeEntireNextValue();
                continue;
            }
            switch (this.parser.nextToken()) {
                case START_ARRAY: {
                    this.writeDataAllText(map.list(fieldName));
                    break;
                }
                case START_OBJECT: {
                    if (this.writeMapDataIfTyped(map, fieldName)) continue block7;
                    this.writeDataAllText(map.map(fieldName), childSelection, false);
                    break;
                }
                case END_OBJECT: {
                    break block7;
                }
                case VALUE_FALSE: 
                case VALUE_TRUE: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: 
                case VALUE_STRING: 
                case VALUE_EMBEDDED_OBJECT: {
                    this.handleString(this.parser, map, fieldName);
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
                default: {
                    throw this.getExceptionWithContext(UserException.dataReadError(), null).message("Unexpected token %s", new Object[]{this.parser.getCurrentToken()}).build(logger);
                }
            }
        }
        map.end();
    }

    private boolean writeMapDataIfTyped(BaseWriter.MapWriter writer, String fieldName) throws IOException {
        return this.mapOutput.run(writer, fieldName);
    }

    private boolean writeListDataIfTyped(BaseWriter.ListWriter writer) throws IOException {
        return this.listOutput.run(writer);
    }

    private void handleString(JsonParser parser, BaseWriter.MapWriter writer, String fieldName) throws IOException {
        try {
            writer.varChar(fieldName).writeVarChar(0, this.workingBuffer.prepareVarCharHolder(parser.getText()), this.workingBuffer.getBuf());
        }
        catch (IllegalArgumentException e) {
            if (parser.getText() == null || parser.getText().isEmpty()) {
                return;
            }
            throw e;
        }
    }

    private void handleString(JsonParser parser, BaseWriter.ListWriter writer) throws IOException {
        writer.varChar().writeVarChar(0, this.workingBuffer.prepareVarCharHolder(parser.getText()), this.workingBuffer.getBuf());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeData(BaseWriter.ListWriter list) throws IOException {
        block16: {
            list.startList();
            try {
                block14: while (true) {
                    switch (this.parser.nextToken()) {
                        case START_ARRAY: {
                            this.writeData(list.list());
                            break;
                        }
                        case START_OBJECT: {
                            if (this.writeListDataIfTyped(list)) continue block14;
                            this.writeData(list.map(), FieldSelection.ALL_VALID, false);
                            break;
                        }
                        case END_ARRAY: {
                            this.addIfNotInitialized(list);
                        }
                        case END_OBJECT: {
                            break block16;
                        }
                        case VALUE_FALSE: 
                        case VALUE_EMBEDDED_OBJECT: {
                            list.bit().writeBit(0);
                            break;
                        }
                        case VALUE_TRUE: {
                            list.bit().writeBit(1);
                            break;
                        }
                        case VALUE_NULL: {
                            throw UserException.unsupportedError().message("Null values are not supported in lists by default. Please set `store.json.all_text_mode` to true to read lists containing nulls. Be advised that this will treat JSON null values as a string containing the word 'null'.", new Object[0]).build(logger);
                        }
                        case VALUE_NUMBER_FLOAT: {
                            list.float8().writeFloat8(this.parser.getDoubleValue());
                            break;
                        }
                        case VALUE_NUMBER_INT: {
                            if (this.readNumbersAsDouble) {
                                list.float8().writeFloat8(this.parser.getDoubleValue());
                                break;
                            }
                            list.bigInt().writeBigInt(this.parser.getLongValue());
                            break;
                        }
                        case VALUE_STRING: {
                            this.handleString(this.parser, list);
                            break;
                        }
                        default: {
                            throw UserException.dataReadError().message("Unexpected token %s", new Object[]{this.parser.getCurrentToken()}).build(logger);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw this.getExceptionWithContext(e, null).build(logger);
            }
        }
        list.endList();
    }

    private void addIfNotInitialized(BaseWriter.ListWriter list) {
        if (list.getValueCapacity() == 0) {
            this.emptyArrayWriters.add(list);
        }
    }

    private void writeDataAllText(BaseWriter.ListWriter list) throws IOException {
        list.startList();
        block7: while (true) {
            switch (this.parser.nextToken()) {
                case START_ARRAY: {
                    this.writeDataAllText(list.list());
                    continue block7;
                }
                case START_OBJECT: {
                    if (this.writeListDataIfTyped(list)) continue block7;
                    this.writeDataAllText(list.map(), FieldSelection.ALL_VALID, false);
                    continue block7;
                }
                case END_ARRAY: {
                    this.addIfNotInitialized(list);
                }
                case END_OBJECT: {
                    break block7;
                }
                case VALUE_FALSE: 
                case VALUE_TRUE: 
                case VALUE_NULL: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: 
                case VALUE_STRING: 
                case VALUE_EMBEDDED_OBJECT: {
                    this.handleString(this.parser, list);
                    continue block7;
                }
                default: {
                    throw this.getExceptionWithContext(UserException.dataReadError(), null).message("Unexpected token %s", new Object[]{this.parser.getCurrentToken()}).build(logger);
                }
            }
            break;
        }
        list.endList();
    }

    public DrillBuf getWorkBuf() {
        return this.workingBuffer.getBuf();
    }

    public static class Builder {
        private final DrillBuf managedBuf;
        private final WorkingBuffer workingBuffer;
        private List<SchemaPath> columns;
        private final VectorOutput.MapVectorOutput mapOutput;
        private final VectorOutput.ListVectorOutput listOutput;
        private final String currentFieldName = "<none>";
        private boolean readNumbersAsDouble;
        private boolean skipOuterList;
        private boolean allTextMode;
        private boolean enableNanInf;
        private boolean enableEscapeAnyChar;

        public Builder(DrillBuf managedBuf) {
            this.managedBuf = managedBuf;
            this.workingBuffer = new WorkingBuffer(managedBuf);
            this.mapOutput = new VectorOutput.MapVectorOutput(this.workingBuffer);
            this.listOutput = new VectorOutput.ListVectorOutput(this.workingBuffer);
            this.enableNanInf = true;
        }

        public Builder readNumbersAsDouble(boolean readNumbersAsDouble) {
            this.readNumbersAsDouble = readNumbersAsDouble;
            return this;
        }

        public Builder skipOuterList(boolean skipOuterList) {
            this.skipOuterList = skipOuterList;
            return this;
        }

        public Builder allTextMode(boolean allTextMode) {
            this.allTextMode = allTextMode;
            return this;
        }

        public Builder enableNanInf(boolean enableNanInf) {
            this.enableNanInf = enableNanInf;
            return this;
        }

        public Builder enableEscapeAnyChar(boolean enableEscapeAnyChar) {
            this.enableEscapeAnyChar = enableEscapeAnyChar;
            return this;
        }

        public Builder defaultSchemaPathColumns() {
            this.columns = GroupScan.ALL_COLUMNS;
            return this;
        }

        public Builder schemaPathColumns(List<SchemaPath> columns) {
            this.columns = columns;
            return this;
        }

        public JsonReader build() {
            if (this.columns == null) {
                throw new IllegalStateException("You need to set SchemaPath columns in order to build JsonReader");
            }
            assert (Preconditions.checkNotNull(this.columns).size() > 0) : "JSON record reader requires at least one column";
            return new JsonReader(this);
        }
    }
}

