/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.SchemaChangeRuntimeException;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.ZeroVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;

public abstract class BaseRepeatedValueVector
extends BaseValueVector
implements RepeatedValueVector {
    public static final ValueVector DEFAULT_DATA_VECTOR = ZeroVector.INSTANCE;
    public static final String OFFSETS_VECTOR_NAME = "$offsets$";
    public static final String DATA_VECTOR_NAME = "$data$";
    public static final MaterializedField OFFSETS_FIELD = MaterializedField.create("$offsets$", Types.required(TypeProtos.MinorType.UINT4));
    protected final UInt4Vector offsets;
    protected ValueVector vector;

    protected BaseRepeatedValueVector(MaterializedField field, BufferAllocator allocator) {
        this(field, allocator, DEFAULT_DATA_VECTOR);
    }

    protected BaseRepeatedValueVector(MaterializedField field, BufferAllocator allocator, ValueVector vector) {
        super(field, allocator);
        this.offsets = new UInt4Vector(OFFSETS_FIELD, allocator);
        this.vector = Preconditions.checkNotNull(vector, "data vector cannot be null");
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = this.vector.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        return success;
    }

    @Override
    public UInt4Vector getOffsetVector() {
        return this.offsets;
    }

    @Override
    public ValueVector getDataVector() {
        return this.vector;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.offsets.setInitialCapacity(numRecords + 1);
        this.vector.setInitialCapacity(numRecords * 5);
    }

    @Override
    public int getValueCapacity() {
        int offsetValueCapacity = Math.max(this.offsets.getValueCapacity() - 1, 0);
        if (this.vector == DEFAULT_DATA_VECTOR) {
            return offsetValueCapacity;
        }
        return Math.min(this.vector.getValueCapacity(), offsetValueCapacity);
    }

    @Override
    protected UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.offsets.getMetadata()).addChild(this.vector.getMetadata());
    }

    @Override
    public int getBufferSize() {
        if (this.getAccessor().getValueCount() == 0) {
            return 0;
        }
        return this.offsets.getBufferSize() + this.vector.getBufferSize();
    }

    @Override
    public int getAllocatedSize() {
        return this.offsets.getAllocatedSize() + this.vector.getAllocatedSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.offsets.getBufferSizeFor(valueCount + 1) + this.vector.getBufferSizeFor(valueCount);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.singleton(this.getDataVector()).iterator();
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.vector.clear();
        super.clear();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.offsets.getBuffers(false), this.vector.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain();
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        UserBitShared.SerializedField offsetMetadata = metadata.getChild(0);
        this.offsets.load(offsetMetadata, buffer);
        UserBitShared.SerializedField vectorMetadata = metadata.getChild(1);
        if (this.getDataVector() == DEFAULT_DATA_VECTOR) {
            this.addOrGetVector(VectorDescriptor.create(vectorMetadata.getMajorType()));
        }
        int offsetLength = offsetMetadata.getBufferLength();
        int vectorLength = vectorMetadata.getBufferLength();
        this.vector.load(vectorMetadata, buffer.slice(offsetLength, vectorLength));
    }

    @Override
    public int size() {
        return this.vector == DEFAULT_DATA_VECTOR ? 0 : 1;
    }

    @Override
    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(VectorDescriptor descriptor) {
        TypeProtos.MajorType actual;
        boolean created = false;
        if (this.vector == DEFAULT_DATA_VECTOR && descriptor.getType().getMinorType() != TypeProtos.MinorType.LATE) {
            MaterializedField field = descriptor.withName(DATA_VECTOR_NAME).getField();
            this.vector = BasicTypeHelper.getNewVector(field, this.allocator);
            assert (field.equals(this.vector.getField()));
            this.getField().addChild(field);
            created = true;
        }
        if (!(actual = this.vector.getField().getType()).equals(descriptor.getType())) {
            String msg = String.format("Inner vector type mismatch. Requested type: [%s], actual type: [%s]", descriptor.getType(), actual);
            throw new SchemaChangeRuntimeException(msg);
        }
        return new AddOrGetResult<ValueVector>(this.vector, created);
    }

    protected void replaceDataVector(ValueVector v) {
        this.vector.clear();
        this.vector = v;
    }

    public void setChildVector(ValueVector childVector) {
        assert (this.vector == DEFAULT_DATA_VECTOR);
        this.replaceDataVector(childVector);
        this.field.addChild(childVector.getField());
        assert (this.field.getChildren().size() == 1);
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.offsets.collectLedgers(ledgers);
        this.vector.collectLedgers(ledgers);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int entryCount = this.offsets.getAccessor().get(valueCount);
        return this.offsets.getPayloadByteCount(valueCount) + this.vector.getPayloadByteCount(entryCount);
    }

    @Override
    public void exchange(ValueVector other) {
        BaseRepeatedValueVector target = (BaseRepeatedValueVector)other;
        this.vector.exchange(target.vector);
        this.offsets.exchange(target.offsets);
    }

    public abstract class BaseRepeatedMutator
    extends BaseValueVector.BaseMutator
    implements RepeatedValueVector.RepeatedMutator {
        @Override
        public void startNewValue(int index) {
            while (BaseRepeatedValueVector.this.offsets.getValueCapacity() <= index) {
                BaseRepeatedValueVector.this.offsets.reAlloc();
            }
            BaseRepeatedValueVector.this.offsets.getMutator().setSafe(index + 1, BaseRepeatedValueVector.this.offsets.getAccessor().get(index));
            this.setValueCount(index + 1);
        }

        @Override
        public void setValueCount(int valueCount) {
            BaseRepeatedValueVector.this.offsets.getMutator().setValueCount(valueCount == 0 ? 0 : valueCount + 1);
            int childValueCount = valueCount == 0 ? 0 : BaseRepeatedValueVector.this.offsets.getAccessor().get(valueCount);
            BaseRepeatedValueVector.this.vector.getMutator().setValueCount(childValueCount);
        }

        public int getInnerValueCountAt(int index) {
            return BaseRepeatedValueVector.this.offsets.getAccessor().get(index + 1) - BaseRepeatedValueVector.this.offsets.getAccessor().get(index);
        }
    }

    public abstract class BaseRepeatedAccessor
    extends BaseValueVector.BaseAccessor
    implements RepeatedValueVector.RepeatedAccessor {
        @Override
        public int getValueCount() {
            return Math.max(BaseRepeatedValueVector.this.offsets.getAccessor().getValueCount() - 1, 0);
        }

        @Override
        public int getInnerValueCount() {
            return BaseRepeatedValueVector.this.vector.getAccessor().getValueCount();
        }

        @Override
        public int getInnerValueCountAt(int index) {
            return BaseRepeatedValueVector.this.offsets.getAccessor().get(index + 1) - BaseRepeatedValueVector.this.offsets.getAccessor().get(index);
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        @Override
        public boolean isEmpty(int index) {
            return false;
        }
    }

    protected static abstract class BaseRepeatedValueVectorTransferPair<T extends BaseRepeatedValueVector>
    implements TransferPair {
        protected final T target;
        protected final TransferPair[] children;
        final /* synthetic */ BaseRepeatedValueVector this$0;

        protected BaseRepeatedValueVectorTransferPair(T target) {
            this.this$0 = this$0;
            this.target = (BaseRepeatedValueVector)Preconditions.checkNotNull(target);
            if (((BaseRepeatedValueVector)target).getDataVector() == DEFAULT_DATA_VECTOR) {
                ((BaseRepeatedValueVector)target).addOrGetVector(VectorDescriptor.create(this$0.getDataVector().getField()));
                ((BaseRepeatedValueVector)target).getDataVector().allocateNew();
            }
            this.children = new TransferPair[]{this$0.getOffsetVector().makeTransferPair(((BaseRepeatedValueVector)target).getOffsetVector()), this$0.getDataVector().makeTransferPair(((BaseRepeatedValueVector)target).getDataVector())};
        }

        @Override
        public void transfer() {
            for (TransferPair child : this.children) {
                child.transfer();
            }
        }

        @Override
        public ValueVector getTo() {
            return this.target;
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            this.target.allocateNew();
            for (int i = 0; i < length; ++i) {
                this.copyValueSafe(startIndex + i, i);
            }
        }

        protected void copyValueSafe(int destIndex, int start, int end) {
            TransferPair vectorTransfer = this.children[1];
            int newIndex = ((BaseRepeatedValueVector)this.target).getOffsetVector().getAccessor().get(destIndex);
            int i = start;
            while (i < end) {
                vectorTransfer.copyValueSafe(i, newIndex);
                ++i;
                ++newIndex;
            }
            ((BaseRepeatedValueVector)this.target).getOffsetVector().getMutator().setSafe(destIndex + 1, newIndex);
        }
    }
}

