/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server;

public class DrillbitStateManager {
    private DrillbitState currentState;

    public DrillbitStateManager(DrillbitState currentState) {
        this.currentState = currentState;
    }

    public DrillbitState getState() {
        return this.currentState;
    }

    public void setState(DrillbitState newState) {
        switch (newState) {
            case ONLINE: {
                if (this.currentState == DrillbitState.STARTUP) {
                    this.currentState = newState;
                    break;
                }
                throw new IllegalStateException("Cannot set drillbit to" + (Object)((Object)newState) + "from" + (Object)((Object)this.currentState));
            }
            case GRACE: {
                if (this.currentState == DrillbitState.ONLINE) {
                    this.currentState = newState;
                    break;
                }
                throw new IllegalStateException("Cannot set drillbit to" + (Object)((Object)newState) + "from" + (Object)((Object)this.currentState));
            }
            case DRAINING: {
                if (this.currentState == DrillbitState.GRACE) {
                    this.currentState = newState;
                    break;
                }
                throw new IllegalStateException("Cannot set drillbit to" + (Object)((Object)newState) + "from" + (Object)((Object)this.currentState));
            }
            case OFFLINE: {
                if (this.currentState == DrillbitState.DRAINING) {
                    this.currentState = newState;
                    break;
                }
                throw new IllegalStateException("Cannot set drillbit to" + (Object)((Object)newState) + "from" + (Object)((Object)this.currentState));
            }
            case SHUTDOWN: {
                if (this.currentState == DrillbitState.OFFLINE) {
                    this.currentState = newState;
                    break;
                }
                throw new IllegalStateException("Cannot set drillbit to" + (Object)((Object)newState) + "from" + (Object)((Object)this.currentState));
            }
            default: {
                throw new IllegalArgumentException(newState.name());
            }
        }
    }

    public static enum DrillbitState {
        STARTUP,
        ONLINE,
        GRACE,
        DRAINING,
        OFFLINE,
        SHUTDOWN;

    }
}

