/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user.clusterclient;

import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import oadd.com.google.common.collect.Maps;
import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.drill.common.config.DrillProperties;
import oadd.org.apache.drill.common.exceptions.DrillIOException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.NonTransientRpcException;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.user.QueryResultHandler;
import oadd.org.apache.drill.exec.rpc.user.UserClient;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.AbstractDrillClusterClient;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillConnection;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillSession;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillConnectionImpl
extends UserClient
implements DrillConnection {
    private static final Logger logger = LoggerFactory.getLogger(DrillConnection.class);
    private final AbstractDrillClusterClient clusterClient;
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private final ConcurrentMap<UserProtos.SessionHandle, DrillSessionImpl> sessions = Maps.newConcurrentMap();

    DrillConnectionImpl(AbstractDrillClusterClient clusterClient, CoordinationProtos.DrillbitEndpoint endpoint, Properties props) throws NonTransientRpcException {
        super(clusterClient.clientName, clusterClient.config, props, clusterClient.supportComplexTypes, clusterClient.allocator, clusterClient.eventLoopGroup, clusterClient.executor, endpoint);
        this.clusterClient = clusterClient;
        this.endpoint = endpoint;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.clusterClient.getAllocator();
    }

    @Override
    public DrillSession newSession(Properties properties) throws DrillIOException {
        UserProtos.NewSessionRequest request = UserProtos.NewSessionRequest.newBuilder().setProperties(DrillProperties.createFromProperties(properties).serializeForServer()).build();
        UserProtos.SessionHandle handle = (UserProtos.SessionHandle)this.send(UserProtos.RpcType.NEW_SESSION, request, UserProtos.SessionHandle.class, new ByteBuf[0]).checkedGet();
        if (!handle.hasSessionId()) {
            throw new DrillIOException("Server could not create a new session.");
        }
        DrillSessionImpl newSession = new DrillSessionImpl(this, handle);
        DrillSessionImpl oldSession = this.sessions.putIfAbsent(handle, newSession);
        if (oldSession != null) {
            throw new IllegalStateException("Two sessions with the same handle.");
        }
        return newSession;
    }

    protected final QueryResultHandler getResultHandler() {
        return this.queryResultHandler;
    }

    protected void sessionClosedDirectly(UserProtos.SessionHandle handle) {
        DrillSession session = (DrillSession)this.sessions.remove(handle);
        if (session != null) {
            try {
                this.send(UserProtos.RpcType.CLOSE_SESSION, handle, GeneralRPCProtos.Ack.class, new ByteBuf[0]).checkedGet();
            }
            catch (RpcException e) {
                logger.warn("failed to close session", e);
            }
        }
    }

    public void close(boolean invokedDirectly) {
        if (invokedDirectly) {
            this.clusterClient.connectionClosedDirectly(this.endpoint);
        }
        for (DrillSessionImpl session : this.sessions.values()) {
            session.close(false);
        }
        this.sessions.clear();
        super.close();
    }

    @Override
    public void close() {
        this.close(true);
    }
}

