/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.logical.data;

import java.util.Iterator;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonTypeName;
import oadd.com.google.common.collect.Iterators;
import oadd.org.apache.drill.common.JSONOptions;
import oadd.org.apache.drill.common.logical.data.AbstractSingleBuilder;
import oadd.org.apache.drill.common.logical.data.LogicalOperator;
import oadd.org.apache.drill.common.logical.data.SinkOperator;
import oadd.org.apache.drill.common.logical.data.visitors.LogicalVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="store")
public class Store
extends SinkOperator {
    static final Logger logger = LoggerFactory.getLogger(Store.class);
    private final String storageEngine;
    private final JSONOptions target;

    @JsonCreator
    public Store(@JsonProperty(value="storageengine") String storageEngine, @JsonProperty(value="target") JSONOptions target) {
        this.storageEngine = storageEngine;
        this.target = target;
    }

    public String getStorageEngine() {
        return this.storageEngine;
    }

    public JSONOptions getTarget() {
        return this.target;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitStore(this, value);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.singletonIterator(this.getInput());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractSingleBuilder<Store, Builder> {
        private String storageEngine;
        private JSONOptions target;

        public Builder storageEngine(String storageEngine) {
            this.storageEngine = storageEngine;
            return this;
        }

        public Builder target(JSONOptions target) {
            this.target = target;
            return this;
        }

        @Override
        public Store internalBuild() {
            return new Store(this.storageEngine, this.target);
        }
    }
}

