/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.reflections.scanners;

import oadd.com.google.common.base.Joiner;
import oadd.javassist.CannotCompileException;
import oadd.javassist.ClassPool;
import oadd.javassist.CtBehavior;
import oadd.javassist.CtClass;
import oadd.javassist.CtConstructor;
import oadd.javassist.LoaderClassPath;
import oadd.javassist.NotFoundException;
import oadd.javassist.bytecode.MethodInfo;
import oadd.javassist.expr.ConstructorCall;
import oadd.javassist.expr.ExprEditor;
import oadd.javassist.expr.FieldAccess;
import oadd.javassist.expr.MethodCall;
import oadd.javassist.expr.NewExpr;
import oadd.org.reflections.ReflectionsException;
import oadd.org.reflections.scanners.AbstractScanner;
import oadd.org.reflections.util.ClasspathHelper;

public class MemberUsageScanner
extends AbstractScanner {
    private ClassPool classPool;

    public void scan(Object cls) {
        try {
            CtClass ctClass = this.getClassPool().get(this.getMetadataAdapter().getClassName(cls));
            for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
                this.scanMember(ctConstructor);
            }
            for (CtBehavior ctBehavior : ctClass.getDeclaredMethods()) {
                this.scanMember(ctBehavior);
            }
            ctClass.detach();
        }
        catch (Exception e) {
            throw new ReflectionsException("Could not scan method usage for " + this.getMetadataAdapter().getClassName(cls), e);
        }
    }

    void scanMember(CtBehavior member) throws CannotCompileException {
        final String key = member.getDeclaringClass().getName() + "." + member.getMethodInfo().getName() + "(" + this.parameterNames(member.getMethodInfo()) + ")";
        member.instrument(new ExprEditor(){

            public void edit(NewExpr e) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(e.getConstructor().getDeclaringClass().getName() + "." + "<init>" + "(" + MemberUsageScanner.this.parameterNames(e.getConstructor().getMethodInfo()) + ")", e.getLineNumber(), key);
                }
                catch (NotFoundException e1) {
                    throw new ReflectionsException("Could not find new instance usage in " + key, e1);
                }
            }

            public void edit(MethodCall m4) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(m4.getMethod().getDeclaringClass().getName() + "." + m4.getMethodName() + "(" + MemberUsageScanner.this.parameterNames(m4.getMethod().getMethodInfo()) + ")", m4.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + m4.getClassName() + " in " + key, e);
                }
            }

            public void edit(ConstructorCall c) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(c.getConstructor().getDeclaringClass().getName() + "." + "<init>" + "(" + MemberUsageScanner.this.parameterNames(c.getConstructor().getMethodInfo()) + ")", c.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + c.getClassName() + " in " + key, e);
                }
            }

            public void edit(FieldAccess f) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(f.getField().getDeclaringClass().getName() + "." + f.getFieldName(), f.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + f.getFieldName() + " in " + key, e);
                }
            }
        });
    }

    private void put(String key, int lineNumber, String value) {
        if (this.acceptResult(key)) {
            this.getStore().put(key, value + " #" + lineNumber);
        }
    }

    String parameterNames(MethodInfo info) {
        return Joiner.on(", ").join(this.getMetadataAdapter().getParameterNames(info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPool getClassPool() {
        if (this.classPool == null) {
            MemberUsageScanner memberUsageScanner = this;
            synchronized (memberUsageScanner) {
                this.classPool = new ClassPool();
                ClassLoader[] classLoaders = this.getConfiguration().getClassLoaders();
                if (classLoaders == null) {
                    classLoaders = ClasspathHelper.classLoaders(new ClassLoader[0]);
                }
                for (ClassLoader classLoader : classLoaders) {
                    this.classPool.appendClassPath(new LoaderClassPath(classLoader));
                }
            }
        }
        return this.classPool;
    }
}

