/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.quorum.auth;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;
import oadd.org.apache.jute.BinaryInputArchive;
import oadd.org.apache.jute.BinaryOutputArchive;
import oadd.org.apache.zookeeper.Login;
import oadd.org.apache.zookeeper.server.quorum.QuorumAuthPacket;
import oadd.org.apache.zookeeper.server.quorum.auth.QuorumAuth;
import oadd.org.apache.zookeeper.server.quorum.auth.QuorumAuthServer;
import oadd.org.apache.zookeeper.server.quorum.auth.SaslQuorumServerCallbackHandler;
import oadd.org.apache.zookeeper.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaslQuorumAuthServer
implements QuorumAuthServer {
    private static final Logger LOG = LoggerFactory.getLogger(SaslQuorumAuthServer.class);
    private static final int MAX_RETRIES = 5;
    private final Login serverLogin;
    private final boolean quorumRequireSasl;

    public SaslQuorumAuthServer(boolean quorumRequireSasl, String loginContext, Set<String> authzHosts) throws SaslException {
        this.quorumRequireSasl = quorumRequireSasl;
        try {
            AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(loginContext);
            if (entries == null || entries.length == 0) {
                throw new LoginException("SASL-authentication failed because the specified JAAS configuration section '" + loginContext + "' could not be found.");
            }
            SaslQuorumServerCallbackHandler saslServerCallbackHandler = new SaslQuorumServerCallbackHandler(Configuration.getConfiguration(), loginContext, authzHosts);
            this.serverLogin = new Login(loginContext, saslServerCallbackHandler);
            this.serverLogin.startThreadIfNeeded();
        }
        catch (Throwable e) {
            throw new SaslException("Failed to initialize authentication mechanism using SASL", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void authenticate(Socket sock, DataInputStream din) throws SaslException {
        dout = null;
        ss = null;
        try {
            block19: {
                if (QuorumAuth.nextPacketIsAuth(din)) break block19;
                if (this.quorumRequireSasl) {
                    throw new SaslException("Learner " + sock.getRemoteSocketAddress() + " not trying to authenticate and authentication is required");
                }
                var10_5 = null;
                if (ss == null) return;
                ** GOTO lbl66
            }
            token = this.receive(din);
            tries = 0;
            dout = new DataOutputStream(sock.getOutputStream());
            challenge = null;
            mechOpt = System.getProperty("zookeeper.authMech");
            if (mechOpt == null) {
                mechOpt = "GSSAPI";
            }
            SaslQuorumAuthServer.LOG.debug("SaslQuorunAuthServer::authenticate, creating SASL server with mechOpt: " + mechOpt);
            ss = SecurityUtils.createSaslServer(this.serverLogin.getSubject(), "zookeeper-quorum", "zk-quorum-sasl-md5", this.serverLogin.callbackHandler, SaslQuorumAuthServer.LOG, mechOpt);
            while (!ss.isComplete()) {
                challenge = ss.evaluateResponse(token);
                if (ss.isComplete()) continue;
                if (++tries > 5) {
                    this.send(dout, challenge, QuorumAuth.Status.ERROR);
                    SaslQuorumAuthServer.LOG.warn("Failed to authenticate using SASL, server addr: {}, retries={} exceeded.", (Object)sock.getRemoteSocketAddress(), (Object)tries);
                    break;
                }
                this.send(dout, challenge, QuorumAuth.Status.IN_PROGRESS);
                token = this.receive(din);
            }
            if (ss.isComplete()) {
                this.send(dout, challenge, QuorumAuth.Status.SUCCESS);
                SaslQuorumAuthServer.LOG.info("Successfully completed the authentication using SASL. learner addr: {}", (Object)sock.getRemoteSocketAddress());
            }
            ** GOTO lbl72
        }
        catch (Exception e) {
            try {
                if (dout != null) {
                    this.send(dout, new byte[0], QuorumAuth.Status.ERROR);
                }
            }
            catch (IOException ioe) {
                SaslQuorumAuthServer.LOG.warn("Exception while sending failed status", ioe);
            }
            if (this.quorumRequireSasl) {
                SaslQuorumAuthServer.LOG.error("Failed to authenticate using SASL", e);
                throw new SaslException("Failed to authenticate using SASL: " + e.getMessage());
            }
            SaslQuorumAuthServer.LOG.warn("Failed to authenticate using SASL", e);
            SaslQuorumAuthServer.LOG.warn("Maintaining learner connection despite SASL authentication failure. server addr: {}, {}: {}", new Object[]{sock.getRemoteSocketAddress(), "quorum.auth.serverRequireSasl", this.quorumRequireSasl});
            var10_7 = null;
            if (ss == null) return;
            try {
                ss.dispose();
                return;
            }
            catch (SaslException e) {
                SaslQuorumAuthServer.LOG.error("SaslServer dispose() failed", e);
            }
            return;
        }
        {
            catch (Throwable var9_19) {
                var10_8 = null;
                if (ss == null) throw var9_19;
                ** try [egrp 3[TRYBLOCK] [7 : 438->448)] { 
lbl61:
                // 1 sources

                ss.dispose();
                throw var9_19;
lbl63:
                // 1 sources

                catch (SaslException e) {
                    SaslQuorumAuthServer.LOG.error("SaslServer dispose() failed", e);
                }
                throw var9_19;
            }
lbl66:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [7 : 438->448)] { 
lbl67:
            // 1 sources

            ss.dispose();
            return;
lbl69:
            // 1 sources

            catch (SaslException e) {
                SaslQuorumAuthServer.LOG.error("SaslServer dispose() failed", e);
            }
            return;
lbl72:
            // 1 sources

            var10_6 = null;
            if (ss == null) return;
            try {}
            catch (SaslException e) {}
            SaslQuorumAuthServer.LOG.error("SaslServer dispose() failed", e);
            return;
            ss.dispose();
            return;
        }
    }

    private byte[] receive(DataInputStream din) throws IOException {
        QuorumAuthPacket authPacket = new QuorumAuthPacket();
        BinaryInputArchive bia = BinaryInputArchive.getArchive(din);
        authPacket.deserialize(bia, "qpconnect");
        return authPacket.getToken();
    }

    private void send(DataOutputStream dout, byte[] challenge, QuorumAuth.Status s2) throws IOException {
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(dout);
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(bufferedOutput);
        QuorumAuthPacket authPacket = challenge == null && s2 != QuorumAuth.Status.SUCCESS ? QuorumAuth.createPacket(QuorumAuth.Status.IN_PROGRESS, null) : QuorumAuth.createPacket(s2, challenge);
        boa.writeRecord(authPacket, "qpconnect");
        bufferedOutput.flush();
    }
}

