/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.metastore;

import java.util.Collection;
import oadd.org.apache.drill.metastore.BaseMetadata;
import oadd.org.apache.drill.metastore.CollectableTableStatisticsKind;

public enum TableStatisticsKind implements CollectableTableStatisticsKind
{
    ROW_COUNT("rowCount"){

        @Override
        public Long mergeStatistics(Collection<? extends BaseMetadata> statistics) {
            long rowCount = 0L;
            for (BaseMetadata baseMetadata : statistics) {
                Long statRowCount = this.getValue(baseMetadata);
                if (statRowCount == null || statRowCount == -1L) {
                    rowCount = -1L;
                    break;
                }
                rowCount += statRowCount.longValue();
            }
            return rowCount;
        }

        @Override
        public Long getValue(BaseMetadata metadata) {
            Long rowCount = (Long)metadata.getStatistic(this);
            return rowCount != null ? rowCount : -1L;
        }

        @Override
        public boolean isExact() {
            return true;
        }
    }
    ,
    EST_ROW_COUNT("rowcount"){

        @Override
        public Double mergeStatistics(Collection<? extends BaseMetadata> statisticsList) {
            double rowCount = 0.0;
            for (BaseMetadata baseMetadata : statisticsList) {
                Double statRowCount = (Double)baseMetadata.getStatistic(this);
                if (statRowCount == null) continue;
                rowCount += statRowCount.doubleValue();
            }
            return rowCount;
        }

        @Override
        public Double getValue(BaseMetadata metadata) {
            return (Double)metadata.getStatistic(this);
        }
    }
    ,
    HAS_STATISTICS("has_statistics"){

        @Override
        public Boolean mergeStatistics(Collection<? extends BaseMetadata> statisticsList) {
            for (BaseMetadata baseMetadata : statisticsList) {
                Boolean hasStatistics = (Boolean)baseMetadata.getStatistic(this);
                if (hasStatistics != null && hasStatistics.booleanValue()) continue;
                return false;
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean getValue(BaseMetadata metadata) {
            return Boolean.TRUE.equals(metadata.getStatistic(this));
        }
    };

    private final String statisticKey;

    private TableStatisticsKind(String statisticKey) {
        this.statisticKey = statisticKey;
    }

    @Override
    public String getName() {
        return this.statisticKey;
    }

    public abstract Object getValue(BaseMetadata var1);
}

