/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.util.ArrayList;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedIntervalDayHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.joda.time.Period;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class RepeatedIntervalDayHolderReaderImpl
extends AbstractFieldReader {
    private NullableIntervalDayHolder holder = new NullableIntervalDayHolder();
    private int index = -1;
    private RepeatedIntervalDayHolder repeatedHolder;

    public RepeatedIntervalDayHolderReaderImpl(RepeatedIntervalDayHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return RepeatedIntervalDayHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public Period readPeriod(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        Period value = this.readPeriod();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public Period readPeriod() {
        if (!this.isSet()) {
            return null;
        }
        Period p = new Period();
        return p.plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }

    @Override
    public Object readObject() {
        ArrayList<Period> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Period p = new Period();
        return p.plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }
}

