/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.util.ArrayList;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedFloat8Holder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class RepeatedFloat8HolderReaderImpl
extends AbstractFieldReader {
    private NullableFloat8Holder holder = new NullableFloat8Holder();
    private int index = -1;
    private RepeatedFloat8Holder repeatedHolder;

    public RepeatedFloat8HolderReaderImpl(RepeatedFloat8Holder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return RepeatedFloat8Holder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public Double readDouble(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        Double value = this.readDouble();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public Double readDouble() {
        if (!this.isSet()) {
            return null;
        }
        Double value = new Double(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        ArrayList<Double> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Double value = new Double(this.holder.value);
        return value;
    }
}

