/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.util.List;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.RepeatedBigIntVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedBigIntWriterImpl;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.BigIntWriter;

public class RepeatedBigIntReaderImpl
extends AbstractFieldReader {
    private final RepeatedBigIntVector vector;

    public RepeatedBigIntReaderImpl(RepeatedBigIntVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(BigIntWriter writer) {
        RepeatedBigIntWriterImpl impl = (RepeatedBigIntWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        RepeatedBigIntWriterImpl impl = (RepeatedBigIntWriterImpl)writer.list(name).bigInt();
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public int size() {
        return this.vector.getAccessor().getInnerValueCountAt(this.idx());
    }

    @Override
    public void read(int arrayIndex, BigIntHolder h2) {
        this.vector.getAccessor().get(this.idx(), arrayIndex, h2);
    }

    @Override
    public void read(int arrayIndex, NullableBigIntHolder h2) {
        this.vector.getAccessor().get(this.idx(), arrayIndex, h2);
    }

    @Override
    public Long readLong(int arrayIndex) {
        return this.vector.getAccessor().getSingleObject(this.idx(), arrayIndex);
    }

    @Override
    public List<Object> readObject() {
        return (List)this.vector.getAccessor().getObject(this.idx());
    }
}

