/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.lang.reflect.Constructor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.ZeroVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractMapVector;
import oadd.org.apache.drill.exec.vector.complex.ListVector;
import oadd.org.apache.drill.exec.vector.complex.UnionVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractPromotableFieldWriter;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleListWriter;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionListWriter;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class PromotableWriter
extends AbstractPromotableFieldWriter {
    private final AbstractMapVector parentContainer;
    private final ListVector listVector;
    private int position;
    private TypeProtos.MinorType type;
    private ValueVector vector;
    private UnionVector unionVector;
    private State state;
    private FieldWriter writer;

    public PromotableWriter(ValueVector v, AbstractMapVector parentContainer) {
        super(null);
        this.parentContainer = parentContainer;
        this.listVector = null;
        this.init(v);
    }

    public PromotableWriter(ValueVector v, ListVector listVector) {
        super(null);
        this.listVector = listVector;
        this.parentContainer = null;
        this.init(v);
    }

    private void init(ValueVector v) {
        if (v instanceof UnionVector) {
            this.state = State.UNION;
            this.unionVector = (UnionVector)v;
            this.writer = new UnionWriter(this.unionVector);
        } else if (v instanceof ZeroVector) {
            this.state = State.UNTYPED;
        } else {
            this.setWriter(v);
        }
    }

    private void setWriter(ValueVector v) {
        this.state = State.SINGLE;
        this.vector = v;
        this.type = v.getField().getType().getMinorType();
        Class<Object> writerClass = BasicTypeHelper.getWriterImpl(v.getField().getType().getMinorType(), v.getField().getDataMode());
        if (writerClass.equals(SingleListWriter.class)) {
            writerClass = UnionListWriter.class;
        }
        Class<? extends ValueVector> vectorClass = BasicTypeHelper.getValueVectorClass(v.getField().getType().getMinorType(), v.getField().getDataMode());
        try {
            Constructor<Object> constructor = null;
            for (Constructor<?> c : writerClass.getConstructors()) {
                if (c.getParameterTypes().length != 3) continue;
                constructor = c;
            }
            if (constructor == null) {
                constructor = writerClass.getConstructor(vectorClass, AbstractFieldWriter.class);
                this.writer = (FieldWriter)constructor.newInstance(this.vector, null);
            } else {
                this.writer = (FieldWriter)constructor.newInstance(this.vector, null, true);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        FieldWriter w = this.getWriter();
        if (w == null) {
            this.position = index;
        } else {
            w.setPosition(index);
        }
    }

    @Override
    protected FieldWriter getWriter(TypeProtos.MinorType type) {
        if (this.state == State.UNION) {
            return this.writer;
        }
        if (this.state == State.UNTYPED) {
            if (type == null) {
                return null;
            }
            Object v = this.listVector.addOrGetVector(new VectorDescriptor(Types.optional(type))).getVector();
            v.allocateNew();
            this.setWriter((ValueVector)v);
            this.writer.setPosition(this.position);
        }
        if (type != this.type) {
            return this.promoteToUnion();
        }
        return this.writer;
    }

    @Override
    public boolean isEmptyMap() {
        return this.writer.isEmptyMap();
    }

    @Override
    protected FieldWriter getWriter() {
        return this.getWriter(this.type);
    }

    private FieldWriter promoteToUnion() {
        String name = this.vector.getField().getName();
        TransferPair tp = this.vector.getTransferPair(this.vector.getField().getType().getMinorType().name().toLowerCase(), this.vector.getAllocator());
        tp.transfer();
        if (this.parentContainer != null) {
            this.unionVector = this.parentContainer.addOrGet(name, Types.optional(TypeProtos.MinorType.UNION), UnionVector.class);
        } else if (this.listVector != null) {
            this.unionVector = this.listVector.promoteToUnion();
        }
        this.unionVector.addVector(tp.getTo());
        this.writer = new UnionWriter(this.unionVector);
        this.writer.setPosition(this.idx());
        for (int i = 0; i < this.idx(); ++i) {
            this.unionVector.getMutator().setType(i, this.vector.getField().getType().getMinorType());
        }
        this.vector = null;
        this.state = State.UNION;
        return this.writer;
    }

    @Override
    public void allocate() {
        this.getWriter().allocate();
    }

    @Override
    public void clear() {
        this.getWriter().clear();
    }

    @Override
    public MaterializedField getField() {
        return this.getWriter().getField();
    }

    @Override
    public int getValueCapacity() {
        return this.getWriter().getValueCapacity();
    }

    @Override
    public void close() throws Exception {
        this.getWriter().close();
    }

    private static enum State {
        UNTYPED,
        SINGLE,
        UNION;

    }
}

