/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.VarCharHolder;
import oadd.org.apache.drill.exec.util.Text;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;

public class NullableVarCharHolderReaderImpl
extends AbstractFieldReader {
    private NullableVarCharHolder holder;

    public NullableVarCharHolderReaderImpl(NullableVarCharHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return NullableVarCharHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(VarCharHolder h2) {
        h2.start = this.holder.start;
        h2.end = this.holder.end;
        h2.buffer = this.holder.buffer;
    }

    @Override
    public void read(NullableVarCharHolder h2) {
        h2.start = this.holder.start;
        h2.end = this.holder.end;
        h2.buffer = this.holder.buffer;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Text readText() {
        if (!this.isSet()) {
            return null;
        }
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        Text text = new Text();
        text.set(value);
        return text;
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        Text text = new Text();
        text.set(value);
        return text;
    }
}

